---
id: 65fd9aa649f6cc84631882a9
title: Step 61
challengeType: 20
dashedName: step-61
---

# --description--

The `__ne__` method is called under the hood when the `!=` operator is used. Define a `__ne__` method with two parameters `self` and `other`. From your new method, return the opposite of `self == other`.

# --hints--

You should define a `__ne__` method within the `R2Vector` class.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("R2Vector").has_function("__ne__")`)) })
```

Your `__ne__` method should have two parameters, `self` and `other`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("R2Vector").find_function("__ne__").has_args("self, other")`)) })
```

The `__ne__` method should return `False` if each attribute of the current instance is equal to the same attribute of `other` and `True` otherwise.

```js
({ test: () => assert(runPython(`
v1 = R2Vector(x=2, y=3)
v2 = R2Vector(x=2, y=3)
v3 = R2Vector(x=0.5, y=1.25)
v4 = R3Vector(x=2, y=3, z=1.5)
v5 = R3Vector(x=2, y=3, z=1.5)
v6 = R3Vector(x=0.5, y=1.25, z=1.5)
not v1 != v2 and v1 != v3 and not v4 != v5 and v5 != v6
`)) })
```

# --seed--

## --seed-contents--

```py
class R2Vector:
    def __init__(self, *, x, y):
        self.x = x
        self.y = y

    def norm(self):
        return sum(val**2 for val in vars(self).values())**0.5

    def __str__(self):
        return str(tuple(getattr(self, i) for i in vars(self)))

    def __repr__(self):
        arg_list = [f'{key}={val}' for key, val in vars(self).items()]
        args = ', '.join(arg_list)
        return f'{self.__class__.__name__}({args})'

    def __add__(self, other):
        if type(self) != type(other):
            return NotImplemented
        kwargs = {i: getattr(self, i) + getattr(other, i) for i in vars(self)}
        return self.__class__(**kwargs)

    def __sub__(self, other):
        if type(self) != type(other):
            return NotImplemented
        kwargs = {i: getattr(self, i) - getattr(other, i) for i in vars(self)}
        return self.__class__(**kwargs)

    def __mul__(self, other):
        if type(other) in (int, float):
            kwargs = {i: getattr(self, i) * other for i in vars(self)}
            return self.__class__(**kwargs)        
        elif type(self) == type(other):
            args = [getattr(self, i) * getattr(other, i) for i in vars(self)]
            return sum(args)            
        return NotImplemented
--fcc-editable-region--
    def __eq__(self, other):
        if type(self) != type(other):
            return NotImplemented
        return all(getattr(self, i) == getattr(other, i) for i in vars(self))
--fcc-editable-region--
class R3Vector(R2Vector):
    def __init__(self, *, x, y, z):
        super().__init__(x=x, y=y)
        self.z = z

v1 = R2Vector(x=2, y=3)
v2 = R2Vector(x=0.5, y=1.25)
print(f'v1 = {v1}')
print(f'v2 = {v2}')
v3 = v1 + v2
print(f'v1 + v2 = {v3}')
v4 = v1 - v2
print(f'v1 - v2 = {v4}')
v5 = v1 * v2
print(f'v1 * v2 = {v5}')
```
