---
id: 65fa9402d1fb5516aa42159d
title: Step 50
challengeType: 20
dashedName: step-50
---

# --description--

Feel free to modify `v3` so that it sums an `R2Vector` instance with an object of a different type, such as an integer or a string. You will be able to see a `TypeError` message printed on the console.

Then, restore the original line and create a new variable `v4`. Assign the difference between `v1` and `v2` to your new variable and print the result following the same structure as the previous f-string.

# --hints--

You should declare a variable `v4` and assign it the difference between `v1` and `v2`.

```js
({
    test: () => assert(runPython(`
      _Node(_code).has_stmt("v4 = v1 - v2")
    `))
})
```

You should print `f'v1 - v2 = {v4}'`.

```js
({ test: () => assert(runPython(`_Node(_code).has_call("print(f'v1 - v2 = {v4}')")`)) })
```

# --seed--

## --seed-contents--

```py
class R2Vector:
    def __init__(self, *, x, y):
        self.x = x
        self.y = y

    def norm(self):
        return sum(val**2 for val in vars(self).values())**0.5

    def __str__(self):
        return str(tuple(getattr(self, i) for i in vars(self)))

    def __repr__(self):
        arg_list = [f'{key}={val}' for key, val in vars(self).items()]
        args = ', '.join(arg_list)
        return f'{self.__class__.__name__}({args})'

    def __add__(self, other):
        if type(self) != type(other):
            return NotImplemented
        kwargs = {i: getattr(self, i) + getattr(other, i) for i in vars(self)}
        return self.__class__(**kwargs)

    def __sub__(self, other):
        if type(self) != type(other):
            return NotImplemented
        kwargs = {i: getattr(self, i) - getattr(other, i) for i in vars(self)}
        return self.__class__(**kwargs)

class R3Vector(R2Vector):
    def __init__(self, *, x, y, z):
        super().__init__(x=x, y=y)
        self.z = z
--fcc-editable-region--
v1 = R2Vector(x=2, y=3)
v2 = R2Vector(x=0.5, y=1.25)
print(f'v1 = {v1}')
print(f'v2 = {v2}')
v3 = v1 + v2
print(f'v1 + v2 = {v3}')
--fcc-editable-region--
```
