---
id: 65f9e0a578b22c1a736f3d82
title: Step 47
challengeType: 20
dashedName: step-47
---

# --description--

Modify your `v2` variable assignment to be an `R2Vector` instance having `x=0.5` and `y=1.25`.

# --hints--

You should modify your `v2` variable assignment to be an `R2Vector` instance having `x=0.5` and `y=1.25`.

```js
({
    test: () => assert(runPython(`
      _Node(_code).has_stmt("v2 = R2Vector(x=0.5, y=1.25)")
    `))
})
```

# --seed--

## --seed-contents--

```py
class R2Vector:
    def __init__(self, *, x, y):
        self.x = x
        self.y = y

    def norm(self):
        return sum(val**2 for val in vars(self).values())**0.5

    def __str__(self):
        return str(tuple(getattr(self, i) for i in vars(self)))

    def __repr__(self):
        arg_list = [f'{key}={val}' for key, val in vars(self).items()]
        args = ', '.join(arg_list)
        return f'{self.__class__.__name__}({args})'

    def __add__(self, other):
        if type(self) != type(other):
            return NotImplemented
        kwargs = {i: getattr(self, i) + getattr(other, i) for i in vars(self)}
        return self.__class__(**kwargs)

    def __sub__(self, other):
        if type(self) != type(other):
            return NotImplemented
        kwargs = {i: getattr(self, i) - getattr(other, i) for i in vars(self)}
        return self.__class__(**kwargs)

class R3Vector(R2Vector):
    def __init__(self, *, x, y, z):
        super().__init__(x=x, y=y)
        self.z = z
--fcc-editable-region--
v1 = R2Vector(x=2, y=3)
v2 = R3Vector(x=2, y=2, z=3)
print(f'v1 = {v1}')
print(f'v2 = {v2}')
--fcc-editable-region--
```
