---
id: 65f9cb678070ca1668898c70
title: Step 44
challengeType: 20
dashedName: step-44
---

# --description--

In the same way `__add__` is called under the hood when two objects are added together, the `__sub__` method is called implicitly in case of subtraction.

Now, define an empty `__sub__` method and give two parameters: `self`, and `other`. Inside your new method, create an if statement to check if `self` and `other` do not belong to the same class and return `NotImplemented`, as you did previously.

# --hints--

You should define a `__sub__` method within the `R2Vector` class.

```js
({
    test: () => assert(runPython(`
      _Node(_code).find_class("R2Vector").has_function("__sub__")
    `))
})
```

Your `__sub__` method should have two parameters, `self` and `other`.

```js
({
    test: () => assert(runPython(`
      _Node(_code).find_class("R2Vector").find_function("__sub__").has_args("self, other")
    `))
})
```

You should create an `if` statement that checks if `self` and `other` does not belong to the same class.

```js
({ test: () => assert(runPython(`
node = _Node(_code).find_class("R2Vector").find_function("__sub__").find_ifs()[0].find_conditions()[0]
node.is_equivalent("type(self) != type(other)") or node.is_equivalent("type(other) != type(self)")
    `))
})
```

You should return `NotImplemented` from within the `if` body.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("R2Vector").find_function("__sub__").find_ifs()[0].find_bodies()[0].has_return("NotImplemented")`)) })
```

# --seed--

## --seed-contents--

```py
class R2Vector:
    def __init__(self, *, x, y):
        self.x = x
        self.y = y

    def norm(self):
        return sum(val**2 for val in vars(self).values())**0.5

    def __str__(self):
        return str(tuple(getattr(self, i) for i in vars(self)))

    def __repr__(self):
        arg_list = [f'{key}={val}' for key, val in vars(self).items()]
        args = ', '.join(arg_list)
        return f'{self.__class__.__name__}({args})'

    def __add__(self, other):
        if type(self) != type(other):
            return NotImplemented
        kwargs = {i: getattr(self, i) + getattr(other, i) for i in vars(self)}
        return self.__class__(**kwargs)
--fcc-editable-region--
    
--fcc-editable-region--
class R3Vector(R2Vector):
    def __init__(self, *, x, y, z):
        super().__init__(x=x, y=y)
        self.z = z

v1 = R2Vector(x=2, y=3)
v2 = R3Vector(x=2, y=2, z=3)
print(f'v1 = {v1}')
print(f'v2 = {v2}')
```
