---
id: 65f9c2c2006feb1428ad2d4c
title: Step 43
challengeType: 20
dashedName: step-43
---

# --description--

You can unpack a dictionary into keyword arguments by using the `**` operator:

```py
def spam(a, b):
    return a + b

my_dict = {a: 11, b: 4}

spam(**my_dict) # 15
```

Return an instance of the current class by using `__class__` and passing `**kwargs` as the argument.

# --hints--

You should return `self.__class__(**kwargs)` from the `__add__` method.

```js
({
    test: () => assert(runPython(`
      _Node(_code).find_class("R2Vector").find_function("__add__").has_return("self.__class__(**kwargs)")
    `))
})
```

# --seed--

## --seed-contents--

```py
class R2Vector:
    def __init__(self, *, x, y):
        self.x = x
        self.y = y

    def norm(self):
        return sum(val**2 for val in vars(self).values())**0.5

    def __str__(self):
        return str(tuple(getattr(self, i) for i in vars(self)))

    def __repr__(self):
        arg_list = [f'{key}={val}' for key, val in vars(self).items()]
        args = ', '.join(arg_list)
        return f'{self.__class__.__name__}({args})'
--fcc-editable-region--
    def __add__(self, other):
        if type(self) != type(other):
            return NotImplemented
        kwargs = {i: getattr(self, i) + getattr(other, i) for i in vars(self)}
--fcc-editable-region--
class R3Vector(R2Vector):
    def __init__(self, *, x, y, z):
        super().__init__(x=x, y=y)
        self.z = z

v1 = R2Vector(x=2, y=3)
v2 = R3Vector(x=2, y=2, z=3)
print(f'v1 = {v1}')
print(f'v2 = {v2}')
```
