---
id: 65f9b17a638f0d0dcce8c354
title: Step 38
challengeType: 20
dashedName: step-38
---

# --description--

To create a vector space, you need to define how vectors should behave in several cases. Vectors can be added, forming a new vector.

The special method `__add__` can be implemented to override what happens by default when two objects are added together using the `+` operator.

Right now, trying to add two instances of `R2Vector` or `R3Vector` would raise an exception. Create an empty `__add__` method within the `R2Vector` class and give it two parameters: `self`, and `other`.

# --hints--

You should define an `__add__` method within the `R2Vector` class.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("R2Vector").has_function("__add__")`)) })
```

Your `__add__` method should have two parameters, `self` and `other`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("R2Vector").find_function("__add__").has_args("self, other")`)) })
```

# --seed--

## --seed-contents--

```py
class R2Vector:
    def __init__(self, *, x, y):
        self.x = x
        self.y = y

    def norm(self):
        return sum(val**2 for val in vars(self).values())**0.5

    def __str__(self):
        return str(tuple(getattr(self, i) for i in vars(self)))

    def __repr__(self):
        arg_list = [f'{key}={val}' for key, val in vars(self).items()]
        args = ', '.join(arg_list)
        return f'{self.__class__.__name__}({args})'
--fcc-editable-region--
    
--fcc-editable-region--
class R3Vector(R2Vector):
    def __init__(self, *, x, y, z):
        super().__init__(x=x, y=y)
        self.z = z

v1 = R2Vector(x=2, y=3)
v2 = R3Vector(x=2, y=2, z=3)
print(f'v1 = {v1}')
print(f'v2 = {v2}')
```
