---
id: 65f93d4647ce2670dc6f095c
title: Step 31
challengeType: 20
dashedName: step-31
---

# --description--

The `__repr__` method is called under the hood by the `repr` function. Verify that `__repr__` works properly by adding `f'\nrepr = {repr(v1)}'` and `f'\nrepr = {repr(v2)}'` as the second argument to your first and second `print` calls, respectively.

# --hints--

You should add `f'\nrepr = {repr(v1)}'` as the second argument to your `print(f'v1 = {v1}')` call.

```js
({ test: () => assert(runPython(`_Node(_code).has_call("print(f'v1 = {v1}', f'\\\\nrepr = {repr(v1)}')")`)) })
```

You should add `f'\nrepr = {repr(v2)}'` as the second argument to your `print(f'v2 = {v2}')` call.

```js
({ test: () => assert(runPython(`_Node(_code).has_call("print(f'v2 = {v2}', f'\\\\nrepr = {repr(v2)}')")`)) })
```

# --seed--

## --seed-contents--

```py
class R2Vector:
    def __init__(self, *, x, y):
        self.x = x
        self.y = y

    def norm(self):
        return sum(val**2 for val in vars(self).values())**0.5

    def __str__(self):
        return str(tuple(getattr(self, i) for i in vars(self)))

    def __repr__(self):
        arg_list = [f'{key}={val}' for key, val in vars(self).items()]
        args = ', '.join(arg_list)
        return f'{self.__class__.__name__}({args})'

class R3Vector(R2Vector):
    def __init__(self, *, x, y, z):
        super().__init__(x=x, y=y)
        self.z = z
--fcc-editable-region--
v1 = R2Vector(x=2, y=3)
v2 = R3Vector(x=2, y=2, z=3)
print(f'v1 = {v1}')
print(f'v2 = {v2}')
--fcc-editable-region--
```
