---
id: 65f93b67169a9c703264458a
title: Step 30
challengeType: 20
dashedName: step-30
---

# --description--

Since the method should return the string to instantiate the object for `R2Vector` as well as `R3Vector` when inherited, you cannot build the string specifying the class name.

You can access the name of a class with `__class__.__name__`. Add a `return` statement to the `__repr__` method and return the string necessary to instantiate the object.

# --hints--

You should use `__class__.__name__` to build the f-string needed to instantiate a vector object and return it from the `__repr__` method.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("R2Vector").find_function("__repr__").has_return("f'{self.__class__.__name__}({args})'")`)) })
```

# --seed--

## --seed-contents--

```py

class R2Vector:
    def __init__(self, *, x, y):
        self.x = x
        self.y = y

    def norm(self):
        return sum(val**2 for val in vars(self).values())**0.5

    def __str__(self):
        return str(tuple(getattr(self, i) for i in vars(self)))
--fcc-editable-region--
    def __repr__(self):
        arg_list = [f'{key}={val}' for key, val in vars(self).items()]
        args = ', '.join(arg_list)
--fcc-editable-region--
class R3Vector(R2Vector):
    def __init__(self, *, x, y, z):
        super().__init__(x=x, y=y)
        self.z = z

v1 = R2Vector(x=2, y=3)
v2 = R3Vector(x=2, y=2, z=3)
print(f'v1 = {v1}')
print(f'v2 = {v2}')
```
