---
id: 65f876d17832001e8e1abb05
title: Step 28
challengeType: 20
dashedName: step-28
---

# --description--

Declare a variable `arg_list`. Give it the value of a list comprehension that iterates over `key` and `val` for each key-value pair in `vars(self).items()` and computes the f-string `f'{key}={val}'` at each iteration.

# --hints--

You should declare a variable `arg_list`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("R2Vector").find_function("__repr__").has_variable("arg_list")`)) })
```

You should assign a list comprehension that iterates over `vars(self).items()` to `arg_list`.

```js
({ test: () => runPython(`
import ast
var = _Node(_code).find_class("R2Vector").find_function("__repr__").find_variable("arg_list")
assert isinstance(var.tree.value, ast.ListComp), "Expected arg_list to be a list comprehension"
assert (actual := var.find_comp_iters()[0].is_equivalent("vars(self).items()")), f"Expected vars(self).items(), got {actual}"
`) })
```

The list comprehension assigned to `arg_list` should use `key` and `val` to iterate over `vars(self).items()`.

```js
({ test: () => assert(runPython(`
_Node(_code).find_class("R2Vector").find_function("__repr__").find_variable("arg_list").find_comp_targets()[0].is_equivalent("key, val")
`)) })
```

The list comprehension assigned to `arg_list` should compute the string `f'{key}={val}'` for each key-value pair in `vars(self).items()`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("R2Vector").find_function("__repr__").find_variable("arg_list").find_comp_expr().is_equivalent("f'{key}={val}'")`)) })
```

# --seed--

## --seed-contents--

```py

class R2Vector:
    def __init__(self, *, x, y):
        self.x = x
        self.y = y

    def norm(self):
        return sum(val**2 for val in vars(self).values())**0.5

    def __str__(self):
        return str(tuple(getattr(self, i) for i in vars(self)))
--fcc-editable-region--
    def __repr__(self):
        pass
--fcc-editable-region--
class R3Vector(R2Vector):
    def __init__(self, *, x, y, z):
        super().__init__(x=x, y=y)
        self.z = z

v1 = R2Vector(x=2, y=3)
v2 = R3Vector(x=2, y=2, z=3)
print(f'v1 = {v1}')
print(f'v2 = {v2}')
```
