---
id: 642349b5b7bae31af21cd5f8
title: Step 36
challengeType: 0
dashedName: step-36
---

# --description--

To put everything you have learned together, update your `dearRegex` to map the vowels to the corresponding numbers (note that `i` should match `1`, and also match the pipe symbol `|`), and to match whole words.

With that, your spam filter project is complete.

# --hints--

Your `dearRegex` should use a character class to match `e` or `3`.

```js
assert.match(dearRegex.source, /\[(e3|3e)\]/);
```

Your `dearRegex` should use a character class to match `a`, `@`, or `4`.

```js
assert.match(dearRegex.source, /\[(a@4|a4@|4a@|4@a|@a4|@4a)\]/);
```

Your `dearRegex` should use a character class to match `i`, `1`, or `|`.

```js
assert.match(dearRegex.source, /\[(i1\||i\|1|1i\||1\|i|\|1i|\|i1)\]/);
```

Your `dearRegex` should use a non-capturing group.

```js
assert.match(dearRegex.source, /\(\?:/);
```

Your `dearRegex` should use a non-capturing group to match `\s` or `^`.

```js
assert.match(dearRegex.source, /\(\?:(\^\|\\s|\\s\|\^)\)/);
```

Your `dearRegex` should use a second non-capturing group.

```js
assert.lengthOf(dearRegex.source.match(/\(\?:/g), 2);
```

Your `dearRegex` should use a non-capturing group to match `\s` or `$`.

```js
assert.match(dearRegex.source, /\(\?:(\$\|\\s|\\s\|\$)\)/);
```

Your `dearRegex` should match `dear friend`.

```js
assert.match('dear friend', dearRegex);
```

Your `dearRegex` should match `d34r fr13nd`.

```js
assert.match('d34r fr13nd', dearRegex);
```

Your `dearRegex` should match `d3@r fr|3nd`.

```js
assert.match('d3@r fr|3nd', dearRegex);
```

Your `dearRegex` should match `my dear friend Naomi`.

```js
assert.match('my dear friend Naomi', dearRegex);
```

Your `dearRegex` should match `dear friend Naomi`.

```js
assert.match('dear friend Naomi', dearRegex);
```

Your `dearRegex` should match `my dear friend`.

```js
assert.match('my dear friend', dearRegex);
```

Your `dearRegex` should not match `non-dear friend`.

```js
assert.notMatch('non-dear friend', dearRegex);
```

Your `dearRegex` should not match `dear friend-o`.

```js
assert.notMatch('dear friend-o', dearRegex);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width" />
    <title>Learn Regular Expressions by Building a Spam Filter</title>
    <link rel="stylesheet" href="styles.css" />
  </head>

  <body>
    <header class="main-text">
      <h1 class="title">Is this Spam?</h1>
      <p class="description">
        Enter a phrase to check if it would be marked as spam or not.
      </p>
    </header>

    <main>
      <label class="message-label" for="message-input">Message: </label>
      <textarea
        placeholder="Enter message here"
        value=""
        type="text"
        name="message"
        id="message-input"
        rows="10"
        cols="40"
      ></textarea>
      <button class="btn" id="check-message-btn" type="button">
        Check message
      </button>
      <p id="result"></p>
    </main>

    <footer class="footer">&copy; freeCodeCamp</footer>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
*,
*::before,
*::after {
  box-sizing: border-box;
  margin: 0;
  padding: 0;
}

:root {
  --dark-grey: #1b1b32;
  --light-grey: #f5f6f7;
  --golden-yellow: #fecc4c;
  --yellow: #ffcc4c;
  --gold: #feac32;
  --orange: #ffac33;
  --dark-orange: #f89808;
}

body {
  background-color: var(--dark-grey);
  color: var(--light-grey);
}

body,
#message-input:placeholder-shown {
  text-align: center;
}

textarea {
  max-width: 90%;
}

.main-text {
  margin: 25px 0;
}

.title {
  font-size: 2.5rem;
}

.description {
  margin-top: 15px;
  font-size: 1.4rem;
}

.message-label {
  display: block;
  margin-bottom: 20px;
  font-size: 1.5rem;
}

#message-input:placeholder-shown,
textarea {
  font-size: 1.1rem;
}

.btn {
  display: block;
  cursor: pointer;
  width: 200px;
  margin: 10px auto;
  color: var(--dark-grey);
  background-color: var(--gold);
  background-image: linear-gradient(var(--golden-yellow), var(--orange));
  border-color: var(--gold);
  border-width: 3px;
}

.btn:hover {
  background-image: linear-gradient(var(--yellow), var(--dark-orange));
}

#result {
  font-size: 2rem;
  margin: 20px 0;
}

.footer {
  margin-top: 10px;
}
```

```js
const messageInput = document.getElementById("message-input");
const result = document.getElementById("result");
const checkMessageButton = document.getElementById("check-message-btn");

const helpRegex = /please help|assist me/i;
const dollarRegex = /[0-9]+\s*(?:hundred|thousand|million|billion)?\s+dollars/i;
const freeRegex = /(?:^|\s)fr[e3][e3] m[o0]n[e3]y(?:$|\s)/i;
const stockRegex = /(?:^|\s)[s5][t7][o0][c{[(]k [a@4]l[e3]r[t7](?:$|\s)/i;
--fcc-editable-region--
const dearRegex = /dear friend/i;
--fcc-editable-region--

const denyList = [helpRegex, dollarRegex, freeRegex, stockRegex, dearRegex];

const isSpam = (msg) => denyList.some((regex) => regex.test(msg));

checkMessageButton.addEventListener("click", () => {
  if (messageInput.value === "") {
    alert("Please enter a message.");
    return;
  }

  result.textContent = isSpam(messageInput.value)
    ? "Oh no! This looks like a spam message."
    : "This message does not seem to contain any spam.";
  messageInput.value = "";
});
```

# --solutions--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width" />
    <title>Learn Regular Expressions by Building a Spam Filter</title>
    <link rel="stylesheet" href="styles.css" />
  </head>

  <body>
    <header class="main-text">
      <h1 class="title">Is this Spam?</h1>
      <p class="description">
        Enter a phrase to check if it would be marked as spam or not.
      </p>
    </header>

    <main>
      <label class="message-label" for="message-input">Message: </label>
      <textarea
        placeholder="Enter message here"
        value=""
        type="text"
        name="message"
        id="message-input"
        rows="10"
        cols="40"
      ></textarea>
      <button class="btn" id="check-message-btn" type="button">
        Check message
      </button>
      <p id="result"></p>
    </main>

    <footer class="footer">&copy; freeCodeCamp</footer>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
*,
*::before,
*::after {
  box-sizing: border-box;
  margin: 0;
  padding: 0;
}

:root {
  --dark-grey: #1b1b32;
  --light-grey: #f5f6f7;
  --golden-yellow: #fecc4c;
  --yellow: #ffcc4c;
  --gold: #feac32;
  --orange: #ffac33;
  --dark-orange: #f89808;
}

body {
  background-color: var(--dark-grey);
  color: var(--light-grey);
}

body,
#message-input:placeholder-shown {
  text-align: center;
}

textarea {
  max-width: 90%;
}

.main-text {
  margin: 25px 0;
}

.title {
  font-size: 2.5rem;
}

.description {
  margin-top: 15px;
  font-size: 1.4rem;
}

.message-label {
  display: block;
  margin-bottom: 20px;
  font-size: 1.5rem;
}

#message-input:placeholder-shown,
textarea {
  font-size: 1.1rem;
}

.btn {
  display: block;
  cursor: pointer;
  width: 200px;
  margin: 10px auto;
  color: var(--dark-grey);
  background-color: var(--gold);
  background-image: linear-gradient(var(--golden-yellow), var(--orange));
  border-color: var(--gold);
  border-width: 3px;
}

.btn:hover {
  background-image: linear-gradient(var(--yellow), var(--dark-orange));
}

#result {
  font-size: 2rem;
  margin: 20px 0;
}

.footer {
  margin-top: 10px;
}
```

```js
const messageInput = document.getElementById("message-input");
const result = document.getElementById("result");
const checkMessageButton = document.getElementById("check-message-btn");

const helpRegex = /please help|assist me/i;
const dollarRegex = /[0-9]+\s*(?:hundred|thousand|million|billion)?\s+dollars/i;
const freeRegex = /(?:^|\s)fr[e3][e3] m[o0]n[e3]y(?:$|\s)/i;
const stockRegex = /(?:^|\s)[s5][t7][o0][c{[(]k [a@4]l[e3]r[t7](?:$|\s)/i;
const dearRegex = /(?:^|\s)d[e3][a@4]r fr[i1|][e3]nd(?:$|\s)/i;

const denyList = [helpRegex, dollarRegex, freeRegex, stockRegex, dearRegex];

const isSpam = (msg) => denyList.some((regex) => regex.test(msg));

checkMessageButton.addEventListener("click", () => {
  if (messageInput.value === "") {
    alert("Please enter a message.");
    return;
  }

  result.textContent = isSpam(messageInput.value)
    ? "Oh no! This looks like a spam message."
    : "This message does not seem to contain any spam.";
  messageInput.value = "";
});
```
