---
id: 6577333feab1e8e927014f03
title: Step 63
challengeType: 20
dashedName: step-63
---

# --description--

Having `all([expression for i in iterable])`, means that a new list is created by evaluating `expression` for each `i` in `iterable`. After the `all()` function iterates over the newly created list, the list is deleted automatically, since it is no longer needed.

Memory can be saved by using a generator expression. Generator expressions follow the syntax of list comprehensions but they use parentheses instead of square brackets.

Change your list comprehension into a generator expression by removing the square brackets.

# --hints--

You should turn your list comprehension into a generator expression by removing the square brackets.

```js
({ test: () => assert.match(code, /^(\s*)if\s+all\s*\(\s*constraint\s*<=\s*len\s*\(\s*re\.findall\s*\(\s*pattern\s*,\s*password\s*\)\s*\)\s*for\s+constraint\s*,\s*pattern\s+in\s+constraints\s*\)\s*:\s*^\1\s{4}break/m) })
```

# --seed--

## --seed-contents--

```py
import re
import secrets
import string


def generate_password(length, nums, special_chars, uppercase, lowercase):
    # Define the possible characters for the password
    letters = string.ascii_letters
    digits = string.digits
    symbols = string.punctuation

    # Combine all characters
    all_characters = letters + digits + symbols

    while True:
        password = ''
        # Generate password
        for _ in range(length):
            password += secrets.choice(all_characters)
       
        constraints = [
            (nums, r'\d'),
            (lowercase, r'[a-z]'),
            (uppercase, r'[A-Z]'),            
            (special_chars, fr'[{symbols}]')            
        ]

        # Check constraints
        count = 0
--fcc-editable-region--
        if all(
            [
                constraint <= len(re.findall(pattern, password))
                for constraint, pattern in constraints
            ]
        ):
--fcc-editable-region--
            break
    
    return password

# new_password = generate_password(8)
# print(new_password)
```
