---
id: 6565bd4265158360de8e2ae7
title: Step 59
challengeType: 20
dashedName: step-59
---

# --description--

Turn the expression inside your `for` loop into an `if` statement. Use the existing expression `constraint <= len(re.findall(pattern, password))` as the `if` condition.

Inside the new conditional statement, increment the `count` value by `1`.

# --hints--

You should turn `constraint <= len(re.findall(pattern, password))` into the `if` condition.

```js
({ test: () => {
    const commentless_code = __helpers.python.removeComments(code);
    const {block_body} = __helpers.python.getBlock(commentless_code, /for\s+constraint\s*,\s*pattern\s+in\s+constraints\s*/);
    assert(block_body.match(/^\s+if\s+constraint\s*<=\s*len\s*\(\s*re\.findall\s*\(\s*pattern\s*,\s*password\s*\)\s*\)\s*:/));
  }
})
```

You should increment `count` by one inside your new `if` statement.

```js
({ test: () => {
    const commentless_code = __helpers.python.removeComments(code);
    const {block_body} = __helpers.python.getBlock(commentless_code, /if\s+constraint\s*<=\s*len\s*\(\s*re\.findall\s*\(\s*pattern\s*,\s*password\s*\)\s*\)\s*/);
    assert(block_body.match(/^\s+(count\s*\+=\s*1|count\s*=\s*count\s*\+\s*1)/));
  }
})
```

# --seed--

## --seed-contents--

```py
import re
import secrets
import string


def generate_password(length, nums, special_chars, uppercase, lowercase):
    # Define the possible characters for the password
    letters = string.ascii_letters
    digits = string.digits
    symbols = string.punctuation

    # Combine all characters
    all_characters = letters + digits + symbols

    while True:
        password = ''
        # Generate password
        for _ in range(length):
            password += secrets.choice(all_characters)
       
        constraints = [
            (nums, r'\d'),
            (lowercase, r'[a-z]'),
            (uppercase, r'[A-Z]'),            
            (special_chars, fr'[{symbols}]')            
        ]
--fcc-editable-region--         
        # Check constraints
        count = 0
        for constraint, pattern in constraints:
            constraint <= len(re.findall(pattern, password))
--fcc-editable-region--
    return password

# new_password = generate_password(8)
# print(new_password)
```
