---
id: 6564f0279e23ce924eedd1b2
title: Step 51
challengeType: 20
dashedName: step-51
---

# --description--

Since the underscore character is a valid character for variable names, it is included in the `\w` character class (equivalent to `[a-zA-Z0-9_]`), which can be conveniently used to match variable names.

Therefore, the `\W` character class is equivalent to `[^a-zA-Z0-9_]` with the underscore character that is not matched. For this reason you cannot use it to match all your special characters.

Delete the last three lines in your code.

# --hints--

You should delete the last three lines in your code.

```js
({ test: () => {
  const commentless_code = __helpers.python.removeComments(code);
  assert.notMatch(commentless_code, /pattern\s*=\s*r("|')\\W\1/);
  assert.notMatch(commentless_code, /quote\s*=\s*("|')_\1/);
  assert.notMatch(commentless_code, /print\(\s*re\.findall\(\s*pattern\s*,\s*quote\s*\)\s*\)/);
}})
```

# --seed--

## --seed-contents--

```py
import re
import secrets
import string


def generate_password(length, nums, special_chars, uppercase, lowercase):
    # Define the possible characters for the password
    letters = string.ascii_letters
    digits = string.digits
    symbols = string.punctuation

    # Combine all characters
    all_characters = letters + digits + symbols

    while True:
        password = ''
        # Generate password
        for _ in range(length):
            password += secrets.choice(all_characters)
        
        constraints = [
            (nums, r'\d'),
            (lowercase, r'[a-z]'),
            (uppercase, r'[A-Z]'),
            (special_chars, r'\W')
        ]        

    return password
    
# new_password = generate_password(8)
# print(new_password)
--fcc-editable-region--
pattern = r'\W'
quote = '_'
print(re.findall(pattern, quote))
--fcc-editable-region--
```
