---
id: 64df202aa1342114cd077920
title: Step 39
challengeType: 20
dashedName: step-39
---

# --description--

If the number of disks is even and the remainder equals `1`, the move is allowed between the source rod and the auxiliary rod. Add an `else` clause to print the allowed movement and call `make_allowed_move()` with the correct arguments.

If you look at the output, you can see that the execution stops at the third move because of an `IndexError`. This happens because the code is still incomplete and needs an `else` clause that you will be writing soon. To make it work, turn your `make_allowed_move()` call into a comment.

# --hints--

You should add an `else` clause.

```js
const tCode = code.replace(/\r/g, '');
const ifBlock = __helpers.python.getBlock(tCode, "if remainder == 1");
assert.match(ifBlock.block_body, /else:/);
```

You should have `print(f'Move {i + 1} allowed between {source} and {auxiliary}')` within the `else` clause.

```js
const tCode = code.replace(/\r/g, '');
const ifBlock = __helpers.python.getBlock(tCode, "if remainder == 1");
const elseBlock = __helpers.python.getBlock(ifBlock.block_body, "else");
assert.match(elseBlock.block_body, /print\(\s*f('|")Move\s\{\s*i\s*\+\s*1\s*\}\sallowed\sbetween\s\{\s*source\s*\}\sand\s\{\s*auxiliary\s*\}\1\s*\)/);
```

You should have `# make_allowed_move(source, auxiliary)` within the `else` clause.

```js
const tCode = code.replace(/\r/g, '');
const ifBlock = __helpers.python.getBlock(tCode, "if remainder == 1");
const elseBlock = __helpers.python.getBlock(ifBlock.block_body, "else");
assert.match(elseBlock.block_body, /# *make_allowed_move\(\s*source\s*,\s*auxiliary\s*\)/);
```

# --seed--

## --seed-contents--

```py
NUMBER_OF_DISKS = 4
number_of_moves = 2**NUMBER_OF_DISKS - 1
rods = {
    'A': list(range(NUMBER_OF_DISKS, 0, -1)),
    'B': [],
    'C': []
}

def make_allowed_move(rod1, rod2):    
    forward = False
    if not rods[rod2]:
        forward = True
    elif rods[rod1] and rods[rod1][-1] < rods[rod2][-1]:
        forward = True              
    if forward:
        print(f'Moving disk {rods[rod1][-1]} from {rod1} to {rod2}')
        rods[rod2].append(rods[rod1].pop())
    else:
        print(f'Moving disk {rods[rod2][-1]} from {rod2} to {rod1}')
        rods[rod1].append(rods[rod2].pop())
    
    # display our progress
    print(rods, '\n')

def move(n, source, auxiliary, target):
    # display starting configuration
    print(rods, '\n')
    for i in range(number_of_moves):
        remainder = (i + 1) % 3
--fcc-editable-region--     
        if remainder == 1:
            if n % 2 != 0:
                print(f'Move {i + 1} allowed between {source} and {target}')
                make_allowed_move(source, target)
            
--fcc-editable-region--            
        elif remainder == 2:
            print(f'Move {i + 1} allowed between {source} and {auxiliary}')
            make_allowed_move(source, auxiliary)
        elif remainder == 0:
            print(f'Move {i + 1} allowed between {auxiliary} and {target}')
            make_allowed_move(auxiliary, target)
           
# initiate call from source A to target C with auxiliary B
move(NUMBER_OF_DISKS, 'A', 'B', 'C')
```
