---
id: 657f0044be09db790b1eb1c5
title: Step 9
challengeType: 20
dashedName: step-9
---

# --description--

In pascal case, strings begin with a capital letter. After converting all the characters to lowercase and adding an underscore to them, there's a chance of having an extra underscore at the start of your string.

The easiest way to fix this is by using the `.strip()` string method, which removes from a string any leading or trailing characters among a set of characters passed as its argument. For example:

```py
original_string = "_example_string_"

clean_string = original_string.strip('_')
```

The `strip()` method is applied to `original_string`. This removes any leading and trailing underscore. The result of the example above would be the string `'example_string'`.

Declare a new variable named `clean_snake_cased_string` and assign it the result of the `.strip()` method applied to `snake_cased_string` , passing `'_'` as the argument to the method.

# --hints--

You should assign the resulting string from `snake_cased_string.strip('_')` to a variable named `clean_snake_cased_string`.

```js
({
    test: () => {
        const transformedCode = code.replace(/\r/g, "");
        const convert_to_snake_case = __helpers.python.getDef("\n" + transformedCode, "convert_to_snake_case");
        const { function_body } = convert_to_snake_case;

        assert.match(function_body, / +clean_snake_cased_string\s*=\s*snake_cased_string.strip\(\s*("|')_\1\s*\)/);
    }
})
```

# --seed--

## --seed-contents--

```py
def convert_to_snake_case(pascal_or_camel_cased_string):
    snake_cased_char_list = []
    for char in pascal_or_camel_cased_string:
        if char.isupper():
            converted_character = '_' + char.lower()
            snake_cased_char_list.append(converted_character)
        else:
            snake_cased_char_list.append(char)
--fcc-editable-region--
    snake_cased_string = ''.join(snake_cased_char_list)
--fcc-editable-region--
```
