---
id: 660f4934fb48f63abd5ae371
title: Step 95
challengeType: 1
dashedName: step-95
---

# --description--

Using `done` to track the number of rows that have been generated is functional, but you can actually clean up the logic a bit further.

Arrays have a special `length` property that allows you to see how many values, or <dfn>elements</dfn>, are in the array. You would access this property using syntax like `myArray.length`.

Note that `rows.length` in the `padRow` call would give you an off-by-one error, because `done` is incremented *before* the call.

Update your condition to check if `rows.length` is less than `count`.

# --hints--

Your `while` loop should check if `rows.length` is less than `count`.

```js
assert.match(__helpers.removeJSComments(code), /while\s*\(\s*rows\.length\s*<\s*count\s*\)/);
```

# --seed--

## --seed-contents--

```js
const character = "#";
const count = 8;
const rows = [];

function padRow(rowNumber, rowCount) {
  return " ".repeat(rowCount - rowNumber) + character.repeat(2 * rowNumber - 1) + " ".repeat(rowCount - rowNumber);
}

// TODO: use a different type of loop
/*for (let i = 1; i <= count; i++) {
  rows.push(padRow(i, count));
}*/

--fcc-editable-region--
let done = 0;

while (done <= count) {
  done++;
  rows.push(padRow(done, count));
}
--fcc-editable-region--

let result = ""

for (const row of rows) {
  result = result + row + "\n";
}

console.log(result);
```
