---
id: 665460392acb7e91db2afad1
title: Step 45
challengeType: 20
dashedName: step-45
---

# --description--

When the second-degree coefficient is positive, the parabola has a minimum point and opens upward, or it is called concave upwards. Instead, when the second-degree coefficient is negative, the parabola has a maximum point and opens downward, or it is called concave downwards.

<img alt="two parabolas with different concavities" src="https://cdn.freecodecamp.org/curriculum/python/parabola.png" style="background-color: white; height: 350px; width: auto; padding: 15px; display: block; margin-right: auto; margin-left: auto; margin-bottom: 1.2rem;">

Declare a `concavity` variable and assign it either the string `'upwards'` or `'downwards'`, depending on the concavity of the parabola. Also, declare a variable named `min_max` and assign it either the string `'min'` or `'max'`, depending on if the vertex is a minimum or a maximum, respectively.

Finally, add the dictionary to return two keys `'min_max'` and `'concavity'` with the values of `min_max'` and `concavity`, respectively.

# --hints--

Your `analyze` method should return a dictionary with four keys, `'x'`, `'y'`, `'min_max'`, and `'concavity'` and the values of `x`, `y`, `min_max`, and `concavity`, respectively.

```js
({ test: () => runPython(`
eq1 = QuadraticEquation(16, 2, 1)
eq2 = QuadraticEquation(-16, 2, 1)
assert eq1.analyze() == {'x': -0.0625, 'y': 0.9375, 'min_max': 'min', 'concavity': 'upwards'}
assert eq2.analyze() == {'x': 0.0625, 'y': 1.0625, 'min_max': 'max', 'concavity': 'downwards'}
`) })
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod
import re


class Equation(ABC):
    degree: int
  
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'Equation' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
        if any(not isinstance(arg, (int, float)) for arg in args):
            raise TypeError("Coefficients must be of type 'int' or 'float'")
        if args[0] == 0:
            raise ValueError("Highest degree coefficient must be different from zero")
        self.coefficients = {(len(args) - n - 1): arg for n, arg in enumerate(args)}

    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )

    def __str__(self):
        terms = []
        for n, coefficient in self.coefficients.items():
            if not coefficient:
                continue
            if n == 0:
                terms.append(f'{coefficient:+}')
            elif n == 1:
                terms.append(f'{coefficient:+}x')
            else:
                terms.append(f"{coefficient:+}x**{n}")
        equation_string = ' '.join(terms) + ' = 0'
        return re.sub(r"(?<!\d)1(?=x)", "", equation_string.strip("+"))        

    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass
        
class LinearEquation(Equation):
    degree = 1
    
    def solve(self):
        a, b = self.coefficients.values()
        x = -b / a
        return [x]

    def analyze(self):
        slope, intercept = self.coefficients.values()
        return {'slope': slope, 'intercept': intercept}

class QuadraticEquation(Equation):
    degree = 2

    def __init__(self, *args):
        super().__init__(*args)
        a, b, c = self.coefficients.values()
        self.delta = b**2 - 4 * a * c

    def solve(self):
        if self.delta < 0:
            return []
        a, b, _ = self.coefficients.values()
        x1 = (-b + (self.delta) ** 0.5) / (2 * a)
        x2 = (-b - (self.delta) ** 0.5) / (2 * a)
        if self.delta == 0:
            return [x1]

        return [x1, x2]
--fcc-editable-region--
    def analyze(self):
        a, b, c = self.coefficients.values()
        x = -b / (2 * a)
        y = a * x**2 + b * x + c
        
        return {'x': x, 'y': y}
--fcc-editable-region--
lin_eq = LinearEquation(2, 3)
print(lin_eq)
quadr_eq = QuadraticEquation(1, 2, 1)
print(quadr_eq)
print(quadr_eq.solve())

```
