---
id: 664f4559c17d2138ae680566
title: Step 37
challengeType: 20
dashedName: step-37
---

# --description--

It's time to implement the `solve` method. When the discriminant of the quadratic equation is negative, the equation does not have real solutions, or roots.

Within the `solve` method, create an `if` statement to check if the discriminant is negative. If it is, return an empty list.

# --hints--

You should create an `if` statement to check if `self.delta` is lower than `0`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("QuadraticEquation").find_function("solve").find_ifs()[0].find_conditions()[0].is_equivalent("self.delta < 0")`)) })
```

You should return an empty list from your new `if` statement.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("QuadraticEquation").find_function("solve").find_ifs()[0].find_bodies()[0].has_return("[]")`)) })
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod
import re


class Equation(ABC):
    degree: int
  
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'Equation' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
        if any(not isinstance(arg, (int, float)) for arg in args):
            raise TypeError("Coefficients must be of type 'int' or 'float'")
        if args[0] == 0:
            raise ValueError("Highest degree coefficient must be different from zero")
        self.coefficients = {(len(args) - n - 1): arg for n, arg in enumerate(args)}

    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )

    def __str__(self):
        terms = []
        for n, coefficient in self.coefficients.items():
            if not coefficient:
                continue
            if n == 0:
                terms.append(f'{coefficient:+}')
            elif n == 1:
                terms.append(f'{coefficient:+}x')
            else:
                terms.append(f"{coefficient:+}x**{n}")
        equation_string = ' '.join(terms) + ' = 0'
        return re.sub(r"(?<!\d)1(?=x)", "", equation_string.strip("+"))        

    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass
        
class LinearEquation(Equation):
    degree = 1
    
    def solve(self):
        a, b = self.coefficients.values()
        x = -b / a
        return x

    def analyze(self):
        slope, intercept = self.coefficients.values()
        return {'slope': slope, 'intercept': intercept}

class QuadraticEquation(Equation):
    degree = 2

    def __init__(self, *args):
        super().__init__(*args)
        a, b, c = self.coefficients.values()
        self.delta = b**2 - 4 * a * c
--fcc-editable-region--
    def solve(self):
        pass
--fcc-editable-region--
    def analyze(self):
        pass


lin_eq = LinearEquation(2, 3)
print(lin_eq)
quadr_eq = QuadraticEquation(11, -1, 1)
print(quadr_eq)

```
