---
id: 664ee8037f4bbe3c0944c35e
title: Step 32
challengeType: 20
dashedName: step-32
---

# --description--

As you can see, the second-degree term is missing from the string representation. Within the `__str__` method, create an `else` clause to handle the case in which the exponent of \\( x \\) is greater than `1`.

Append a string to the `terms` list so that the term is represented as `<coefficient>x**<exponent>`. Display the number sign both for positive and negative coefficients and make sure that the inserted string is suitable to represent equations of degree > 2, too.

# --hints--

You should create an `else` clause after your existing `elif` clause.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Equation").find_function("__str__").find_for_loops()[0].find_ifs()[1].find_conditions()[2].is_empty()`)) })
```

You should append `f'{coefficient:+}x**{n}'` to the `terms` list within your new `else` clause.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Equation").find_function("__str__").find_for_loops()[0].find_ifs()[1].find_bodies()[2].is_equivalent("terms.append(f'{coefficient:+}x**{n}')")`)) })
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod

class Equation(ABC):
    degree: int
  
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'Equation' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
        if any(not isinstance(arg, (int, float)) for arg in args):
            raise TypeError("Coefficients must be of type 'int' or 'float'")
        if args[0] == 0:
            raise ValueError("Highest degree coefficient must be different from zero")
        self.coefficients = {(len(args) - n - 1): arg for n, arg in enumerate(args)}

    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )

    def __str__(self):
        terms = []
        for n, coefficient in self.coefficients.items():
            if not coefficient:
                continue
--fcc-editable-region--
            if n == 0:
                terms.append(f'{coefficient:+}')
            elif n == 1:
                terms.append(f'{coefficient:+}x')
            
--fcc-editable-region--
        equation_string = ' '.join(terms) + ' = 0'
        return equation_string.strip('+')        
    
    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass
        
class LinearEquation(Equation):
    degree = 1
    
    def solve(self):
        a, b = self.coefficients.values()
        x = -b / a
        return x

    def analyze(self):
        slope, intercept = self.coefficients.values()
        return {'slope': slope, 'intercept': intercept}

class QuadraticEquation(Equation):
    degree = 2

    def __init__(self, *args):
        super().__init__(*args)
        a, b, c = self.coefficients.values()
        self.delta = b**2 - 4 * a * c
   
    def solve(self):
        pass
    
    def analyze(self):
        pass


lin_eq = LinearEquation(2, 3)
print(lin_eq)
quadr_eq = QuadraticEquation(11, -1, 1)
print(quadr_eq)

```
