---
id: 664cb04a16fe6938708967ef
title: Step 24
challengeType: 20
dashedName: step-24
---

# --description--

After joining the terms, concatenate the string `' = 0'` to `equation_string` to display the complete equation.

Also, to refine the output, remove any leading `+` sign from `equation_string`.

# --hints--

The `__str__` method should return a different string representation.

```js
({ test: () => assert(runPython(`
eq1 = LinearEquation(4, 2)
str(eq1) == '4x +2 = 0'
`)) })
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod

class Equation(ABC):
    degree: int
  
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'Equation' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
        if any(not isinstance(arg, (int, float)) for arg in args):
            raise TypeError("Coefficients must be of type 'int' or 'float'")
        if args[0] == 0:
            raise ValueError("Highest degree coefficient must be different from zero")
        self.coefficients = {(len(args) - n - 1): arg for n, arg in enumerate(args)}
        
    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )

    def __str__(self):
        terms = []
        for n, coefficient in self.coefficients.items():
            if not coefficient:
                continue
            if n == 0:
                terms.append(f'{coefficient:+}')
            elif n == 1:
                terms.append(f'{coefficient:+}x')
--fcc-editable-region--
        equation_string = ' '.join(terms)
        
        return equation_string
--fcc-editable-region--
        
    
    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass
        
class LinearEquation(Equation):
    degree = 1
    
    def solve(self):
        pass
    
    def analyze(self):
        pass
    
lin_eq = LinearEquation(2, 3)
print(lin_eq)
```
