---
id: 662fc3eba556a6bf800d48c1
title: Step 14
challengeType: 20
dashedName: step-14
---

# --description--

The `isinstance()` built-in function takes two arguments and returns a Boolean indicating if the object passed as the first argument is an instance of the class passed as the second argument.

```py
isinstance(7, int) # True
```

Another thing you want to check is that every argument is a number. After your first `if`, create a `for` loop that iterates over `args` and checks if the argument at the current iteration is not an instance of `int` or `float`. Use the `isinstance()` function and pass it a tuple containing `int` and `float` as the second argument.

If the argument is not a number, raise a `TypeError` saying `"Coefficients must be of type 'int' or 'float'"`.

# --hints--

You should create a `for` loop that iterates over `args` after your `if` statement.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Equation").find_function("__init__").find_for_loops()[0].find_for_iter().is_equivalent("args")`)) })
```

You should create an `if` statement that checks if the current coefficient is not an instance of either `int` or `float` within the `for` loop.

```js
({ test: () => assert(runPython(`
var = str(_Node(_code).find_class("Equation").find_function("__init__").find_for_loops()[0].find_for_vars())
cond1 = f'not isinstance({var}, (int, float))'
cond2 = f'not isinstance({var}, (float, int))'
if_stmt = _Node(_code).find_class("Equation").find_function("__init__").find_for_loops()[0].find_ifs()[0].find_conditions()[0]
if_stmt.is_equivalent(cond1) or if_stmt.is_equivalent(cond2)
`)) })
```

You should use the provided string to raise a `TypeError` within the `if` statement.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Equation").find_function("__init__").find_for_loops()[0].find_ifs()[0].find_bodies()[0].has_stmt("raise TypeError(\\"Coefficients must be of type 'int' or 'float'\\")")
`)) })
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod
--fcc-editable-region--
class Equation(ABC):
    degree: int
    
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'{self.__class__.__name__}' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
--fcc-editable-region--
    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )
    
    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass
        
class LinearEquation(Equation):
    degree = 1
    
    def solve(self):
        pass
    
    def analyze(self):
        pass
    
lin_eq = LinearEquation(2, 3)
```
