---
id: 5efc4f528d6a74d05e68af74
title: Step 58
challengeType: 0
dashedName: step-58
---

# --description--

There's another way to associate an `input` element's text with the element itself. You can nest the text within a `label` element and add a `for` attribute with the same value as the `input` element's `id` attribute.

Given an `input` element as below:

```html
<input id="breakfast" type="radio" name="meal" value="breakfast">
```

An example of a `label` element that is associated to this `input` element is:

```html
<label for="breakfast">Breakfast</label>
```

Associate the text `Loving` with the checkbox by nesting only the text `Loving` in a `label` element and giving it an appropriate `for` attribute.

# --hints--

You should make sure the checkbox element is still present, and you did not make any changes to it. It should stay as it was in the starting code.

```js
const checkboxElementRegex = /\s*<input\s+id\s*=\s*"loving"\s*type\s*=\s*"checkbox"\s*>/;
assert.match(code, checkboxElementRegex);
```

Your checkbox should still have an `id` attribute with the value `loving`.  Expected `--fcc-expected--`, but found `--fcc-actual--`.

```js
const checkboxElementId = document.querySelector('input[type="checkbox"]')?.getAttribute('id');
assert.strictEqual(checkboxElementId, 'loving');
```

You should add a new `label` element after the checkbox element. Make sure it has both an opening and closing tag.

```js
assert.lengthOf(document.querySelectorAll('label'), 3);
assert.lengthOf(code.match(/<\/label\>/g), 3);
```

Your `label` element should be located after your checkbox.

```js
const checkboxElement = document.querySelector('input[type="checkbox"]');
const checkboxSiblingElement = checkboxElement?.nextElementSibling?.nodeName;
assert.strictEqual(checkboxSiblingElement, 'LABEL');
```

Your `label` element should have the text `Loving`.

```js
const checkboxElement = document.querySelector('input[type="checkbox"]');
const checkboxSiblingElementText = checkboxElement?.nextElementSibling?.innerText;

assert.strictEqual(checkboxSiblingElementText, 'Loving');
```

The label text `Loving` should only be inside your new `label` element. Make sure you did not duplicate the text outside the `label` element.

```js
const checkboxElement = document.querySelector('input[type="checkbox"]');
const checkboxSiblingNode = checkboxElement?.nextSibling?.nodeValue ?? '';
const labelElement = checkboxElement?.nextElementSibling;
const labelSiblingNode = labelElement?.nextSibling?.nodeValue ?? '';

assert.notInclude(checkboxSiblingNode, 'Loving');
assert.notInclude(labelSiblingNode, 'Loving');
```

Your `label` element does not have a `for` attribute. Make sure there is a space between the opening `label` tag name and the `for` attribute.

```js
const checkboxElement = document.querySelector('input[type="checkbox"]');
const checkboxSiblingElementAttr = checkboxElement?.nextElementSibling?.getAttribute('for');

assert.isNotNull(checkboxSiblingElementAttr);
```

Your `label` element should have a `for` attribute with the value `loving`.  Expected `--fcc-expected--`, but found `--fcc-actual--`.

```js
const checkboxElement = document.querySelector('input[type="checkbox"]');
const checkboxSiblingElementAttr = checkboxElement?.nextElementSibling?.getAttribute('for');

assert.strictEqual(checkboxSiblingElementAttr, 'loving');
```

There should be a space between your checkbox and your new `label` element.

```js
assert.match(code, />\s+<label\s+for\s*=\s*('|")loving/);
```

# --seed--

## --seed-contents--

```html
<html>
  <body>
    <main>
      <h1>CatPhotoApp</h1>
      <section>
        <h2>Cat Photos</h2>
        <p>Everyone loves <a href="https://cdn.freecodecamp.org/curriculum/cat-photo-app/running-cats.jpg">cute cats</a> online!</p>
        <p>See more <a target="_blank" href="https://freecatphotoapp.com">cat photos</a> in our gallery.</p>
        <a href="https://freecatphotoapp.com"><img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg" alt="A cute orange cat lying on its back."></a>
      </section>
      <section>
        <h2>Cat Lists</h2>
        <h3>Things cats love:</h3>
        <ul>
          <li>catnip</li>
          <li>laser pointers</li>
          <li>lasagna</li>
        </ul>
        <figure>
          <img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/lasagna.jpg" alt="A slice of lasagna on a plate.">
          <figcaption>Cats <em>love</em> lasagna.</figcaption>  
        </figure>
        <h3>Top 3 things cats hate:</h3>
        <ol>
          <li>flea treatment</li>
          <li>thunder</li>
          <li>other cats</li>
        </ol>
        <figure>
          <img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/cats.jpg" alt="Two tabby kittens sleeping together on a couch.">
          <figcaption>Cats <strong>hate</strong> other cats.</figcaption>  
        </figure>
      </section>
      <section>
        <h2>Cat Form</h2>
        <form action="https://freecatphotoapp.com/submit-cat-photo">
          <fieldset>
            <legend>Is your cat an indoor or outdoor cat?</legend>
            <label><input id="indoor" type="radio" name="indoor-outdoor" value="indoor"> Indoor</label>
            <label><input id="outdoor" type="radio" name="indoor-outdoor" value="outdoor"> Outdoor</label>
          </fieldset>
          <fieldset>
            <legend>What's your cat's personality?</legend>
--fcc-editable-region--
            <input id="loving" type="checkbox"> Loving
--fcc-editable-region--
          </fieldset>
          <input type="text" name="catphotourl" placeholder="cat photo URL" required>
          <button type="submit">Submit</button>
        </form>
      </section>
    </main>
  </body>
</html>
```

