---
id: 5ef9b03c81a63668521804e2
title: Step 56
challengeType: 0
dashedName: step-56
---

# --description--

Forms commonly use checkboxes for questions that may have more than one answer. The `input` element with a `type` attribute set to `checkbox` creates a checkbox.

Under the `legend` element you just added, add an `input` with its `type` attribute set to `checkbox` and its text set to:

` Loving`

# --hints--

The `input` element for your checkbox should have an opening tag, but not a closing tag.

```js
assert.isTrue(document.querySelector('fieldset > input') && !code.match(/<\/input\>/g));
```

You should only have added one input element for your checkbox. Remove any extras.

```js
assert.lengthOf(document.querySelectorAll('fieldset > input'), 1);
```

Your new `input` element should be below the `legend` element with the text `What's your cat's personality?`. You have them in the wrong order.

```js
const existingLegendElem = document.querySelectorAll('fieldset > legend')?.[1];
assert.strictEqual(
  existingLegendElem?.nextElementSibling?.nodeName,
  'INPUT'
);
```

Your new `input` element does not have a `type` attribute. Check that there is a space after the opening tag's name.

```js
assert.isTrue(document.querySelector('fieldset > input')?.hasAttribute('type'));
```

Your new `input` element should have a `type` attribute with the value `checkbox`. You have either omitted the value or have a typo. Remember that attribute values should be surrounded with quotation marks.

```js
assert.match(document.querySelector('fieldset > input')?.getAttribute('type'),/^checkbox$/i);
```

Although you have set the new `input` element's `type` attribute to `checkbox`, it is recommended to always surround the value of an attribute with quotation marks.

```js
assert(!/\<\s*input\s+type\s*=\s*checkbox/i.test(code));
```

The text ` Loving` should be located directly to the right of your checkbox. Make sure there is a space between the element and the text. You have either omitted the text or have a typo.

```js
const checkboxInputElem = document.querySelector('input[type="checkbox"]');
assert.match(
  checkboxInputElem?.nextSibling?.nodeValue?.replace(/\s+/g, ' '),
  / Loving/i
);
```

# --seed--

## --seed-contents--

```html
<html>
  <body>
    <main>
      <h1>CatPhotoApp</h1>
      <section>
        <h2>Cat Photos</h2>
        <p>Everyone loves <a href="https://cdn.freecodecamp.org/curriculum/cat-photo-app/running-cats.jpg">cute cats</a> online!</p>
        <p>See more <a target="_blank" href="https://freecatphotoapp.com">cat photos</a> in our gallery.</p>
        <a href="https://freecatphotoapp.com"><img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg" alt="A cute orange cat lying on its back."></a>
      </section>
      <section>
        <h2>Cat Lists</h2>
        <h3>Things cats love:</h3>
        <ul>
          <li>catnip</li>
          <li>laser pointers</li>
          <li>lasagna</li>
        </ul>
        <figure>
          <img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/lasagna.jpg" alt="A slice of lasagna on a plate.">
          <figcaption>Cats <em>love</em> lasagna.</figcaption>  
        </figure>
        <h3>Top 3 things cats hate:</h3>
        <ol>
          <li>flea treatment</li>
          <li>thunder</li>
          <li>other cats</li>
        </ol>
        <figure>
          <img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/cats.jpg" alt="Two tabby kittens sleeping together on a couch.">
          <figcaption>Cats <strong>hate</strong> other cats.</figcaption>  
        </figure>
      </section>
      <section>
        <h2>Cat Form</h2>
        <form action="https://freecatphotoapp.com/submit-cat-photo">
          <fieldset>
            <legend>Is your cat an indoor or outdoor cat?</legend>
            <label><input id="indoor" type="radio" name="indoor-outdoor" value="indoor"> Indoor</label>
            <label><input id="outdoor" type="radio" name="indoor-outdoor" value="outdoor"> Outdoor</label>
          </fieldset>
          <fieldset>
--fcc-editable-region--
            <legend>What's your cat's personality?</legend>
            
--fcc-editable-region--
          </fieldset>
          <input type="text" name="catphotourl" placeholder="cat photo URL" required>
          <button type="submit">Submit</button>
        </form>
      </section>
    </main>
  </body>
</html>
```

