---
id: 65ae458e23954c3469e0c209
title: Step 18
challengeType: 0
dashedName: step-18
---


# --description--

In earlier projects you learned about the `setAttribute` method. Another way to update an attribute in JavaScript is to use the following syntax:

```js
el.attribute = value;
```

The property names for hyphenated HTML attribute values, such as `aria-label`, follow camel case, becoming `ariaLabel`.

```js
el.ariaLabel = "Aria Label Value";
```

Set the `aria-label` attribute for the `input` element to the same value as the `id` attribute.


# --hints--

You should have an `input.ariaLabel`.

```js
assert.match(code, /input\.ariaLabel\s*=/);
```


You should give `input.ariaLabel` the same value as `input.id`.

```js
assert.match(code, /input\.ariaLabel\s*=\s*((letter\s*\+\s*number)|(input.id))/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
const charRange = (start, end) => range(start.charCodeAt(0), end.charCodeAt(0)).map(code => String.fromCharCode(code));

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
  const letters = charRange("A", "J");
  letters.forEach(createLabel);
  range(1, 99).forEach(number => {
     createLabel(number);
--fcc-editable-region--
    letters.forEach(letter => {
     const input = document.createElement("input");
     input.type = "text";
     input.id = letter + number;
 
    })   
--fcc-editable-region--
  })
}
```
