---
id: 64496df724dd3716a71fe971
title: Step 26
challengeType: 0
dashedName: step-26
---

# --description--

Object properties consist of key/value pairs. You can use shorthand property names when declaring an object literal. When using the shorthand property name syntax, the name of the variable becomes the property key and its value the property value.

The following example declares a `user` object with the properties `userId`, `firstName`, and `loggedIn`.

```js
const userId = 1;
const firstName = "John";
const loggedIn = true;

const user = {
  userId,
  firstName,
  loggedIn,
};

console.log(user); // { userId: 1, firstName: 'John', loggedIn: true }
```

To keep track of all of your spreadsheet's functions, declare a `spreadsheetFunctions` object. Using the shorthand notation syntax, set `sum`, `average`, and `median` as properties on the `spreadsheetFunctions` object.

# --hints--

You should declare a `spreadsheetFunctions` variable.

```js
assert.match(code, /(?:const|let|var)\s+spreadsheetFunctions/);
```

You should use `const` to declare your `spreadsheetFunctions` variable.

```js
assert.match(code, /const\s+spreadsheetFunctions/);
```

Your `spreadsheetFunctions` variable should be an object.

```js
assert.isObject(spreadsheetFunctions);
```

Your `spreadsheetFunctions` object should have a `sum` property.

```js
assert.property(spreadsheetFunctions, "sum");
```

Your `sum` property should be your `sum` function.

```js
assert.equal(spreadsheetFunctions?.sum, sum);
```

Your `spreadsheetFunctions` object should have an `average` property.

```js
assert.property(spreadsheetFunctions, "average");
```

Your `average` property should be your `average` function.

```js
assert.equal(spreadsheetFunctions?.average, average);
```

Your `spreadsheetFunctions` object should have a `median` property.

```js
assert.property(spreadsheetFunctions, "median");
```

Your `median` property should be your `median` function.

```js
assert.equal(spreadsheetFunctions?.median, median);
```

You should use destructuring syntax to assign your properties.

```js
const objectText = code.replace(/.*const\s+spreadsheetFunctions\s*=\s*\{([^}]*)}.*/s, "$1");
assert.include(objectText, "sum");
assert.include(objectText, "average");
assert.include(objectText, "median");
assert.notInclude(objectText, ":");
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
const isEven = num => num % 2 === 0;
const sum = nums => nums.reduce((acc, el) => acc + el, 0);
const average = nums => sum(nums) / nums.length;

const median = nums => {
  const sorted = nums.slice().sort((a, b) => a - b);
  const length = sorted.length;
  const middle = length / 2 - 1;
  return isEven(length)
    ? average([sorted[middle], sorted[middle + 1]])
    : sorted[Math.ceil(middle)];
}

--fcc-editable-region--

--fcc-editable-region--

const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
const charRange = (start, end) => range(start.charCodeAt(0), end.charCodeAt(0)).map(code => String.fromCharCode(code));

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
  const letters = charRange("A", "J");
  letters.forEach(createLabel);
  range(1, 99).forEach(number => {
    createLabel(number);
    letters.forEach(letter => {
      const input = document.createElement("input");
      input.type = "text";
      input.id = letter + number;
      input.ariaLabel = letter + number;
      container.appendChild(input);
    })
  })
}
```
