---
id: 64496d80bc174a158c973080
title: Step 25
challengeType: 0
dashedName: step-25
---

# --description--

Check if `length` is even using your `isEven` function. If it is, return the average of the number at the `middle` index and the number after that. If it's odd, return the number at the `middle` index – you'll need to round the `middle` value up.

# --hints--

You should return a value from the `median` function. 

```js
assert.exists(median([2,4,6,8]));
```

If `length` is even, you should return the average of the number at the `middle` index and the number after it. 

```js
assert.strictEqual(median([2,4,6,8]),5); 
assert.strictEqual(median([6,12,18,24]),15); 
```


If `length` is odd, you should return the value at the `middle` index. 

```js
assert.strictEqual(median([2,4,6,8,10]),6); 
assert.strictEqual(median([3,6,9,12,15]),9); 
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
const isEven = num => num % 2 === 0;
const sum = nums => nums.reduce((acc, el) => acc + el, 0);
const average = nums => sum(nums) / nums.length;

--fcc-editable-region--
const median = nums => {
  const sorted = nums.slice().sort((a, b) => a - b);
  const length = sorted.length;
  const middle = length / 2 - 1;

}
--fcc-editable-region--

const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
const charRange = (start, end) => range(start.charCodeAt(0), end.charCodeAt(0)).map(code => String.fromCharCode(code));

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
  const letters = charRange("A", "J");
  letters.forEach(createLabel);
  range(1, 99).forEach(number => {
    createLabel(number);
    letters.forEach(letter => {
      const input = document.createElement("input");
      input.type = "text";
      input.id = letter + number;
      input.ariaLabel = letter + number;
      container.appendChild(input);
    })
  })
}
```
