---
id: 6437133052eaf04d7300e622
title: Step 22
challengeType: 0
dashedName: step-22
---

# --description--

Declare an `average` function which takes an array of numbers as the `nums` parameter. It should return the average of all the numbers in the array.

The average can be calculated by dividing the sum of all the numbers in the array by the length of the array. Remember that you have a `sum` function you can use.

# --hints--

You should declare an `average` variable.

```js
assert.match(code, /(?:let|const|var)\s+average/);
```

You should use `const` to declare your `average` variable.

```js
assert.match(code, /const\s+average/);
```

Your `average` variable should be a function.

```js
assert.isFunction(average);
```

Your `average` function should use arrow syntax.

```js
assert.match(code, /const\s+average\s*=\s*(\([^)]*\)|[^\s()]+)\s*=>/);
```

Your `average` function should have a `nums` parameter.

```js
assert.match(code, /const\s+average\s*=\s*(\(\s*nums\s*\)|nums)/);
```

Your `average` function should use an implicit return.

```js
assert.notMatch(code, /const\s+average\s*=\s*(\(\s*nums\s*\)|nums)\s*=>\s*{/);
```

Your `average` function should return the average value of the `nums` array.

```js
assert.equal(average([1,2,3]), 2);
assert.equal(average([1,2,3,4,5]), 3);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
const isEven = num => num % 2 === 0;
const sum = nums => nums.reduce((acc, el) => acc + el, 0);
--fcc-editable-region--

--fcc-editable-region--

const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
const charRange = (start, end) => range(start.charCodeAt(0), end.charCodeAt(0)).map(code => String.fromCharCode(code));

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
  const letters = charRange("A", "J");
  letters.forEach(createLabel);
  range(1, 99).forEach(number => {
    createLabel(number);
    letters.forEach(letter => {
      const input = document.createElement("input");
      input.type = "text";
      input.id = letter + number;
      input.ariaLabel = letter + number;
      container.appendChild(input);
    })
  })
}
```
