---
id: 643498755d54c6279ba09078
title: Step 20
challengeType: 0
dashedName: step-20
---

# --description--

Most spreadsheet programs include built-in functions for calculation.

Declare a `sum` function that takes a `nums` parameter, which will be an array of numbers. It should return the result of calling `reduce` on the array to sum all of the numbers.

# --hints--

You should declare a `sum` variable.

```js
assert.match(code, /(?:let|const|var)\s+sum/);
```

You should use `const` to declare your `sum` variable.

```js
assert.match(code, /const\s+sum/);
```

Your `sum` variable should be a function.

```js
assert.isFunction(sum);
```

Your `sum` function should use arrow syntax.

```js
assert.match(code, /const\s+sum\s*=\s*(\([^)]*\)|[^\s()]+)\s*=>/);
```

Your `sum` function should have a `nums` parameter.

```js
assert.match(code, /const\s+sum\s*=\s*(\(\s*nums\s*\)|nums)\s*=>/);
```

Your `sum` function should use an implicit return.

```js
assert.notMatch(code, /const\s+sum\s*=\s*(\(\s*nums\s*\)|nums)\s*=>\s*{/);
```

Your `sum` function should return the result of calling `.reduce()` on `nums`.

```js
assert.match(code, /const\s+sum\s*=\s*(\(\s*nums\s*\)|nums)\s*=>\s*nums\.reduce\(/);
```

Your `sum` function should return the sum of all numbers in `nums`.

```js
const numbers = [1, 2, 3, 4, 5];
assert.equal(sum(numbers), 15);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
--fcc-editable-region--

--fcc-editable-region--

const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
const charRange = (start, end) => range(start.charCodeAt(0), end.charCodeAt(0)).map(code => String.fromCharCode(code));

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
  const letters = charRange("A", "J");
  letters.forEach(createLabel);
  range(1, 99).forEach(number => {
    createLabel(number);
    letters.forEach(letter => {
      const input = document.createElement("input");
      input.type = "text";
      input.id = letter + number;
      input.ariaLabel = letter + number;
      container.appendChild(input);
    })
  })
}
```
