---
id: 643475e13dc727231acd0f72
title: Step 17
challengeType: 0
dashedName: step-17
---

# --description--

Now in your nested `.forEach()` call, declare an `input` variable. Use the `.createElement()` method of the `document` object to create an `input` element. Set the `type` attribute to `"text"` and the `id` attribute to `letter + number`.

# --hints--

You should declare an `input` variable.

```js
assert.match(code, /(?:var|let|const)\s+input/)
```

You should use `const` to declare your `input` variable.

```js
assert.match(code, /const\s+input/)
```

You should call the `.createElement()` method of the `document` object.

```js
assert.lengthOf(code.match(/document\.createElement\(/g), 2)
```

You should pass the string `"input"` to the `.createElement()` method.

```js
assert.match(code, /document\.createElement\(\s*('|"|`)input\1\s*\)/)
```

You should assign your new `input` element to your `input` variable.

```js
assert.match(code, /const\s+input\s*=\s*document\.createElement\(\s*('|"|`)input\1\s*\)/)
```

You should access the `type` property of your `input` element.

```js
assert.match(code, /input\.type/);
```

You should set the `type` attribute of your `input` element to `"text"`.

```js
assert.match(code, /input\.type\s*=\s*('|"|`)text\1/)
```

You should access the `id` property of your `input` element.

```js
assert.match(code, /input\.id/);
```

You should set the `id` attribute of your `input` element to `letter + number`.

```js
assert.match(code, /input\.id\s*=\s*letter\s\+\snumber/)
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
const charRange = (start, end) => range(start.charCodeAt(0), end.charCodeAt(0)).map(code => String.fromCharCode(code));

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
  const letters = charRange("A", "J");
  letters.forEach(createLabel);
  range(1, 99).forEach(number => {
    createLabel(number);
--fcc-editable-region--
    letters.forEach(letter => {

    })
--fcc-editable-region--
  })
}
```
