---
id: 64347464f78cd9209545f35c
title: Step 14
challengeType: 0
dashedName: step-14
---

# --description--

Now call the `.forEach()` method of your `letters` array, and pass your `createLabel` function reference as the callback.

You should see some letters appear across the top of your spreadsheet.

# --hints--

You should call the `.forEach()` method on your `letters` array.

```js
assert.match(code, /letters\.forEach\(/);
```

You should pass your `createLabel` function reference to the `.forEach()` method.

```js
assert.match(code, /letters\.forEach\(\s*(?:\(\s*([\S]*)\s*\)|\s*([\S]*))\s*=>\s*createLabel\(\s*\1\2\s*\)\s*\)|letters\.forEach\(\s*createLabel\s*\)/);
```

You should not pass a `createLabel` function call.

```js
assert.notMatch(code, /letters\.forEach\(\s*createLabel\(\s*\)\s*\)/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
const charRange = (start, end) => range(start.charCodeAt(0), end.charCodeAt(0)).map(code => String.fromCharCode(code));

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
  const letters = charRange("A", "J");
--fcc-editable-region--

--fcc-editable-region--
}
```
