---
id: 64345c560591891f64976f7a
title: Step 13
challengeType: 0
dashedName: step-13
---

# --description--

Now that your helper functions are complete, back in your `onload` event handler you should declare a `letters` variable. Assign it the result of calling `charRange()` with the letters `"A"` and `"J"` as arguments.

# --hints--

You should declare a `letters` variable.

```js
assert.match(code, /(?:let|const|var)\s+letters/);
```

You should use `const` to declare your `letters` variable.

```js
assert.match(code, /const\s+letters/);
```

You should assign a `charRange()` call to your `letters` variable.

```js
assert.match(code, /const\s+letters\s*=\s*charRange\(/);
```

You should pass `"A"` as the first argument to your `charRange()` call.

```js
assert.match(code, /const\s+letters\s*=\s*charRange\(\s*('|"|`)A\1/);
```

You should pass `"J"` as the second argument to your `charRange()` call.

```js
assert.match(code, /const\s+letters\s*=\s*charRange\(\s*('|"|`)A\1\s*,\s*('|"|`)J\2\s*\)/)
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
const charRange = (start, end) => range(start.charCodeAt(0), end.charCodeAt(0)).map(code => String.fromCharCode(code));

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
--fcc-editable-region--

--fcc-editable-region--
}
```
