---
id: 64345b810a6e481e5e326849
title: Step 12
challengeType: 0
dashedName: step-12
---

# --description--

`range()` will return an array of numbers, which you need to convert back into characters. Chain the `.map()` method to your `range()` call.

Pass a callback function that takes `code` as the parameter and implicitly returns the value of passing `code` to the `String.fromCharCode()` method.

# --hints--

You should use the `.map()` method.

```js
assert.lengthOf(code.match(/\.map\(/g), 2);
```

You should chain the `.map()` method to your `range` call.

```js
assert.match(code, /const\s+charRange\s*=\s*\(\s*start\s*,\s*end\s*\)\s*=>\s*range\(\s*start\.charCodeAt\(\s*0\s*\)\s*,\s*end\.charCodeAt\(\s*0\s*\)\s*\)\.map\(/);
```

You should use arrow syntax for the `.map()` callback.

```js
assert.match(code, /const\s+charRange\s*=\s*\(\s*start\s*,\s*end\s*\)\s*=>\s*range\(\s*start\.charCodeAt\(\s*0\s*\)\s*,\s*end\.charCodeAt\(\s*0\s*\)\s*\)\.map\(\s*(\(.*\)|[^\s()]+)\s*=>/);
```

Your `.map()` callback should take a `code` parameter.

```js
assert.match(code, /const\s+charRange\s*=\s*\(\s*start\s*,\s*end\s*\)\s*=>\s*range\(\s*start\.charCodeAt\(\s*0\s*\)\s*,\s*end\.charCodeAt\(\s*0\s*\)\s*\)\.map\(\s*(\(\s*code\s*\)|code)\s*=>/);
```

Your `.map()` callback should use an implicit return.

```js
assert.notMatch(code, /const\s+charRange\s*=\s*\(\s*start\s*,\s*end\s*\)\s*=>\s*range\(\s*start\.charCodeAt\(\s*0\s*\)\s*,\s*end\.charCodeAt\(\s*0\s*\)\s*\)\.map\(\s*(\(\s*code\s*\)|code)\s*=>\s*\{/);
```

Your `.map()` callback should return the result of calling `String.fromCharCode()`.

```js
assert.match(code, /const\s+charRange\s*=\s*\(\s*start\s*,\s*end\s*\)\s*=>\s*range\(\s*start\.charCodeAt\(\s*0\s*\)\s*,\s*end\.charCodeAt\(\s*0\s*\)\s*\)\.map\(\s*(\(\s*code\s*\)|code)\s*=>\s*String\.fromCharCode\(/);
```

You should pass the variable `code` to `String.fromCharCode()`.

```js
assert.match(code, /const\s+charRange\s*=\s*\(\s*start\s*,\s*end\s*\)\s*=>\s*range\(\s*start\.charCodeAt\(\s*0\s*\)\s*,\s*end\.charCodeAt\(\s*0\s*\)\s*\)\.map\(\s*(\(\s*code\s*\)|code)\s*=>\s*String\.fromCharCode\(\s*code\s*\)/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
--fcc-editable-region--
const charRange = (start, end) => range(start.charCodeAt(0), end.charCodeAt(0));
--fcc-editable-region--

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
}
```
