---
id: 642e004130958c3975aa3a4a
title: Step 9
challengeType: 0
dashedName: step-9
---

# --description--

Currently your `range` function returns an array with the correct length, but all of the values are the value of `start`. To fix this, chain the `.map()` method to your `.fill()` method.

Pass the `.map()` method a callback which takes `element` and `index` as parameters and returns the sum of those parameters.

# --hints--

You should use the `.map()` method.

```js
assert.match(code, /\.map\(/);
```

You should chain the `.map()` method to your `.fill()` method.

```js
assert.match(code, /const\s+range\s*=\s*\(\s*start\s*,\s*end\s*\)\s*=>\s*Array\(\s*end\s*-\s*start\s*\+\s*1\s*\)\.fill\(\s*start\s*\)\.map\(/);
```

You should pass a callback function to `.map()` using arrow syntax.

```js
assert.match(code, /const\s+range\s*=\s*\(\s*start\s*,\s*end\s*\)\s*=>\s*Array\(\s*end\s*-\s*start\s*\+\s*1\s*\)\.fill\(\s*start\s*\)\.map\(\s*\(.*\)\s*=>/);
```

Your `.map()` callback should take `element` as the first parameter.

```js
assert.match(code, /const\s+range\s*=\s*\(\s*start\s*,\s*end\s*\)\s*=>\s*Array\(\s*end\s*-\s*start\s*\+\s*1\s*\)\.fill\(\s*start\s*\)\.map\(\s*\(\s*element/);
```

Your `.map()` callback should take `index` as the second parameter.

```js
assert.match(code, /const\s+range\s*=\s*\(\s*start\s*,\s*end\s*\)\s*=>\s*Array\(\s*end\s*-\s*start\s*\+\s*1\s*\)\.fill\(\s*start\s*\)\.map\(\s*\(\s*element\s*,\s*index\s*\)\s*=>/);
```

Your `.map()` callback should use an implicit return.

```js
assert.notMatch(code, /const\s+range\s*=\s*\(\s*start\s*,\s*end\s*\)\s*=>\s*Array\(\s*end\s*-\s*start\s*\+\s*1\s*\)\.fill\(\s*start\s*\)\.map\(\s*\(\s*element\s*,\s*index\s*\)\s*=>\s*\{/);
```

Your `.map()` callback should implicitly return the sum of `element` and `index`.

```js
assert.match(code, /const\s+range\s*=\s*\(\s*start\s*,\s*end\s*\)\s*=>\s*Array\(\s*end\s*-\s*start\s*\+\s*1\s*\)\.fill\(\s*start\s*\)\.map\(\s*\(\s*element\s*,\s*index\s*\)\s*=>\s*(element\s*\+\s*index|index\s*\+\s*element)/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
--fcc-editable-region--
const range = (start, end) => Array(end - start + 1).fill(start);
--fcc-editable-region--

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
}
```
