---
id: 6633b4d3271d5b3aea1c1195
title: Step 15
challengeType: 20
dashedName: step-15
---

# --description--

Now it's time for the graph. Create a method `create_trajectory` and replace the last `print` call at the bottom of your code with `print(graph.create_trajectory())`.

As the first step of this new method, make a local copy of the coordinates but where all the values are rounded to integers. Save this new version of the coordinates in a variable named `rounded_coords`, and return this variable.

# --hints--

You should define a method named `create_trajectory`.

```js
({
    test: () => assert(runPython(
        `_Node(_code).find_class('Graph').has_function('create_trajectory')`
    ))
})
```

You should replace `print(graph.create_coordinates_table())` with `print(graph.create_trajectory())`.

```js
({
    test: () => runPython(`
    prints = _Node(_code).find_calls('print')

    assert all(not p.is_equivalent('print(graph.create_coordinates_table())') for p in prints), "print(graph.create_coordinates_table()) should not be present"

    assert any(p.is_equivalent('print(graph.create_trajectory())') for p in prints), "print(graph.create_trajectory()) not found"
    `)
})
```

The function should return `rounded_coords`.

```js
({
    test: () => runPython(`
    assert _Node(_code).find_class('Graph').find_function('create_trajectory').has_return('rounded_coords'), "return rounded_coords missing"
    `)
})
```

The `rounded_coords` variable should contain the rounded coordinates.

```js
({
    test: () => {
        runPython(`
            ball = Projectile(10, 3, 45)
            coordinates = ball.calculate_all_coordinates()
            graph = Graph(coordinates)
            assert [(round(x), round(y)) for x,y in coordinates] == graph.create_trajectory(), "coordinates are not rounded correctly"
        `)
    }
})
```

# --seed--

## --seed-contents--

```py
import math

GRAVITATIONAL_ACCELERATION = 9.81
PROJECTILE = "∙"
x_axis_tick = "T"
y_axis_tick = "⊣"

class Projectile:
    __slots__ = ('__speed', '__height', '__angle')

    def __init__(self, speed, height, angle):
        self.__speed = speed
        self.__height = height
        self.__angle = math.radians(angle)
        
    def __str__(self):
        return f'''
Projectile details:
speed: {self.speed} m/s
height: {self.height} m
angle: {self.angle}°
displacement: {round(self.__calculate_displacement(), 1)} m
'''

    def __calculate_displacement(self):
        horizontal_component = self.__speed * math.cos(self.__angle)
        vertical_component = self.__speed * math.sin(self.__angle)
        squared_component = vertical_component**2
        gh_component = 2 * GRAVITATIONAL_ACCELERATION * self.__height
        sqrt_component = math.sqrt(squared_component + gh_component)
        
        return horizontal_component * (vertical_component + sqrt_component) / GRAVITATIONAL_ACCELERATION
        
    def __calculate_y_coordinate(self, x):
        height_component = self.__height
        angle_component = math.tan(self.__angle) * x
        acceleration_component = GRAVITATIONAL_ACCELERATION * x ** 2 / (
                2 * self.__speed ** 2 * math.cos(self.__angle) ** 2)
        y_coordinate = height_component + angle_component - acceleration_component

        return y_coordinate
    
    def calculate_all_coordinates(self):
        return [
            (x, self.__calculate_y_coordinate(x))
            for x in range(math.ceil(self.__calculate_displacement()))
        ]

    @property
    def height(self):
        return self.__height

    @property
    def angle(self):
        return round(math.degrees(self.__angle))

    @property
    def speed(self):
        return self.__speed

    @height.setter
    def height(self, n):
        self.__height = n

    @angle.setter
    def angle(self, n):
        self.__angle = math.radians(n)

    @speed.setter
    def speed(self, s):
       self.__speed = s
    
    def __repr__(self):
        return f'{self.__class__}({self.speed}, {self.height}, {self.angle})'

class Graph:
    __slots__ = ('__coordinates')

    def __init__(self, coord):
        self.__coordinates = coord

    def __repr__(self):
        return f"Graph({self.__coordinates})"

    def create_coordinates_table(self):
        table = '\n  x      y\n'
        for x, y in self.__coordinates:
            table += f'{x:>3}{y:>7.2f}\n'

        return table

--fcc-editable-region--
    
        

ball = Projectile(10, 3, 45)
print(ball)
coordinates = ball.calculate_all_coordinates()
graph = Graph(coordinates)
print(graph.create_coordinates_table())

--fcc-editable-region--
   
```
