---
id: 663353465bfb14259717da93
title: Step 14
challengeType: 20
dashedName: step-14
---

# --description--

Create a method `create_coordinates_table`, then at the end of the code print `graph.create_coordinates_table())`.

The method should use the `__coordinates` property and return a string containing all the coordinates, where x and y have always the same position, the values for x are always integers, and the values for y are always rounded to two decimal places:

```py
  x      y
  0   3.00
  1   3.90
  2   4.61
  3   5.12
  4   5.43
  5   5.55
  6   5.47
  7   5.19
  8   4.72
  9   4.05
 10   3.19
 11   2.13
 12   0.87  
```

The table should start with a newline character and end with a newline character.

# --hints--

You should have a `create_coordinates_table()` method.

```js
({
    test: () => assert(runPython(
        `_Node(_code).find_class('Graph').has_function('create_coordinates_table')`
    ))
})
```

The `create_coordiantes_table` method for `Projectile(10, 3, 45)` should return `'\n  x      y\n  0   3.00\n  1   3.90\n  2   4.61\n  3   5.12\n  4   5.43\n  5   5.55\n  6   5.47\n  7   5.19\n  8   4.72\n  9   4.05\n 10   3.19\n 11   2.13\n 12   0.87\n'`.

```js
({
    test: () => assert(runPython(
        `a = """
  x      y
  0   3.00
  1   3.90
  2   4.61
  3   5.12
  4   5.43
  5   5.55
  6   5.47
  7   5.19
  8   4.72
  9   4.05
 10   3.19
 11   2.13
 12   0.87
"""
ball = Projectile(10, 3, 45)
g = Graph(ball.calculate_all_coordinates())
g.create_coordinates_table() == a`
    ))
})
```

You should print `graph.create_coordiantes_table()`.

```js
({
    test: () => {
        runPython(`
        prints = _Node(_code).find_calls('print')
        assert any(p.is_equivalent('print(graph.create_coordinates_table())') for p in prints), "print(graph.create_coordiantes_table()) is missing"
        `)
    }
})
```

# --seed--

## --seed-contents--

```py
import math

GRAVITATIONAL_ACCELERATION = 9.81
PROJECTILE = "∙"
x_axis_tick = "T"
y_axis_tick = "⊣"

class Projectile:
    __slots__ = ('__speed', '__height', '__angle')

    def __init__(self, speed, height, angle):
        self.__speed = speed
        self.__height = height
        self.__angle = math.radians(angle)
        
    def __str__(self):
        return f'''
Projectile details:
speed: {self.speed} m/s
height: {self.height} m
angle: {self.angle}°
displacement: {round(self.__calculate_displacement(), 1)} m
'''

    def __calculate_displacement(self):
        horizontal_component = self.__speed * math.cos(self.__angle)
        vertical_component = self.__speed * math.sin(self.__angle)
        squared_component = vertical_component**2
        gh_component = 2 * GRAVITATIONAL_ACCELERATION * self.__height
        sqrt_component = math.sqrt(squared_component + gh_component)
        
        return horizontal_component * (vertical_component + sqrt_component) / GRAVITATIONAL_ACCELERATION
        
    def __calculate_y_coordinate(self, x):
        height_component = self.__height
        angle_component = math.tan(self.__angle) * x
        acceleration_component = GRAVITATIONAL_ACCELERATION * x ** 2 / (
                2 * self.__speed ** 2 * math.cos(self.__angle) ** 2)
        y_coordinate = height_component + angle_component - acceleration_component

        return y_coordinate
    
    def calculate_all_coordinates(self):
        return [
            (x, self.__calculate_y_coordinate(x))
            for x in range(math.ceil(self.__calculate_displacement()))
        ]

    @property
    def height(self):
        return self.__height

    @property
    def angle(self):
        return round(math.degrees(self.__angle))

    @property
    def speed(self):
        return self.__speed

    @height.setter
    def height(self, n):
        self.__height = n

    @angle.setter
    def angle(self, n):
        self.__angle = math.radians(n)

    @speed.setter
    def speed(self, s):
       self.__speed = s
    
    def __repr__(self):
        return f'{self.__class__}({self.speed}, {self.height}, {self.angle})'

class Graph:
    __slots__ = ('__coordinates')

    def __init__(self, coord):
        self.__coordinates = coord
    
    def __repr__(self):
        return f'Graph({self.__coordinates})'

--fcc-editable-region--
    


ball = Projectile(10, 3, 45)
print(ball)
coordinates = ball.calculate_all_coordinates()

graph = Graph(coordinates)

--fcc-editable-region--
```
