---
id: 662f9f65c50bd21d05ffdee9
title: Step 7
challengeType: 20
dashedName: step-7
---

# --description--

Define a method named `calculate_all_coordinates`, which calculates the coordinates for all \\(x\\) values from `0` up to the displacement rounded up (not inclusive), and then returns them as a list of tuples `(x, y)`.

Then, call the `calculate_all_coordinates` method on the `ball` instance and assign the output to a new variable named `coordinates`.

You can use `math.ceil()` to round up a number to the smallest integer greater than or equal to that number.

# --hints--

You should define a `calculate_all_coordinates` method with a single argument, `self` .

```js
({test: () => assert(runPython(`
c = _Node(_code).find_class('Projectile')
c.has_function('calculate_all_coordinates') and c.find_function('calculate_all_coordinates').has_args('self')
`))})
```

You should call the `calculate_all_coordinates` method on `ball` and assign the result to a variable named `coordinates`.

```js
({
    test: () => runPython(`
        assert _Node(_code).has_variable('coordinates'), "coordinates variable is missing"

        assert _Node(_code).find_variable('coordinates').is_equivalent('coordinates = ball.calculate_all_coordinates()'), "wrong value assigned to coordinates variable"
    `)
})
```

The `calculate_all_coordinates` method should return a list containing all the `(x, y)` coordinates.

```js
({test: () => assert(runPython(`
import math

GRAVITATIONAL_ACCELERATION = 9.81
PROJECTILE = "∙"
x_axis_tick = "T"
y_axis_tick = "⊣"
ball = Projectile(12, 13, 14)
expected = [(x, ball._Projectile__calculate_y_coordinate(x)) for x in range(math.ceil(ball._Projectile__calculate_displacement()))]
actual = ball.calculate_all_coordinates()
expected == actual
`))})
```

# --seed--

## --seed-contents--

```py
import math

GRAVITATIONAL_ACCELERATION = 9.81
PROJECTILE = "∙"
x_axis_tick = "T"
y_axis_tick = "⊣"

class Projectile:
    __slots__ = ('__speed', '__height', '__angle')

    def __init__(self, speed, height, angle):
        self.__speed = speed
        self.__height = height
        self.__angle = math.radians(angle)
        
    def __str__(self):
        return f'''
Projectile details:
speed: {self.__speed} m/s
height: {self.__height} m
angle: {round(math.degrees(self.__angle))}°
displacement: {round(self.__calculate_displacement(), 1)} m
'''

    def __calculate_displacement(self):
        horizontal_component = self.__speed * math.cos(self.__angle)
        vertical_component = self.__speed * math.sin(self.__angle)
        squared_component = vertical_component**2
        gh_component = 2 * GRAVITATIONAL_ACCELERATION * self.__height
        sqrt_component = math.sqrt(squared_component + gh_component)
        
        return horizontal_component * (vertical_component + sqrt_component) / GRAVITATIONAL_ACCELERATION
        
    def __calculate_y_coordinate(self, x):
        height_component = self.__height
        angle_component = math.tan(self.__angle) * x
        acceleration_component = GRAVITATIONAL_ACCELERATION * x**2 / (
                2 * self.__speed**2 * math.cos(self.__angle)**2)
        y_coordinate = height_component + angle_component - acceleration_component

        return y_coordinate

    --fcc-editable-region--
    
        
        
ball = Projectile(10, 3, 45)
print(ball)
   --fcc-editable-region--
```
