---
id: 6140c7e645d8e905819f1dd4
title: Step 1
challengeType: 0
dashedName: step-1
demoType: onLoad
---

# --description--

Begin with the standard boilerplate. Add your `DOCTYPE` declaration, your `html` element with the language set to English, your `head` and `body` elements.

Add your `meta` element for the correct `charset`, your `title` element, and a `link` element for the `./styles.css` file.

Set the `title` to `Ferris Wheel`.

# --hints--

Your code should contain the `DOCTYPE` declaration.

```js
assert.match(code, /<!DOCTYPE/gi);
```

You should include a space after the `DOCTYPE` declaration.

```js
assert.match(code, /<!DOCTYPE\s+/gi);
```

You should define the document type to be `html`.

```js
assert.match(code, /<!DOCTYPE\s+html/gi);
```

You should close the `DOCTYPE` declaration with a `>` after the type.

```js
assert.match(code, /<!DOCTYPE\s+html\s*>/gi);
```

Your `html` element should have an opening tag with a `lang` attribute of `en`.

```js
assert.match(code, /<html\s+lang\s*=\s*('|")en\1\s*>/gi);
```

Your `html` element should have a closing tag.

```js
assert.match(code, /<\/html\s*>/);
```

Your `DOCTYPE` declaration should be at the beginning of your HTML.

```js
assert.match(__helpers.removeHtmlComments(code), /^\s*<!DOCTYPE\s+html\s*>/i);
```

You should have an opening `head` tag.

```js
assert.match(code, /<head\s*>/i);
```

You should have a closing `head` tag.

```js
assert.match(code, /<\/head\s*>/i);
```

You should have an opening `body` tag.

```js
assert.match(code, /<body\s*>/i);
```

You should have a closing `body` tag.

```js
assert.match(code, /<\/body\s*>/i);
```

Your `body` element should be the first element after the `head` element.

```js
assert.match(code, /<\/head\s*>\s*<body\s*>/i);
```

Your `head` and `body` elements should be siblings.

```js
assert.strictEqual(document.querySelector('head')?.nextElementSibling?.localName, 'body');
```

Your `head` element should be the first element inside your `html` element.

```js
assert.match(code, /<html\s+lang\s*=\s*('|")en\1\s*>\s*<head\s*>/);
```

Your `head` element should be within the `html` element.

```js
assert.isTrue([...document.querySelector('html')?.children].some(x => x?.localName === 'head'));
```

Your `body` element should be within the `html` element.

```js
assert.isTrue([...document.querySelector('html')?.children].some(x => x?.localName === 'body'));
```

Your code should have a `meta` element.

```js
const meta = document.querySelector('meta');
assert.exists(meta);
```

Your `meta` element should have a `charset` attribute with the value `UTF-8`.

```js
assert.match(code, /<meta\s+charset=('|"|`)UTF-8\1/i);
```

Your `meta` element should be inside the `head` element.

```js
const regex = /<head\s*>(?:.|\r|\n)*?<meta\s+charset=('|"|`)utf-8\1(?:.|\r|\n)*?<\/head\s*>/i;
assert.match(code, regex);
```

Your code should have a `title` element.

```js
const title = document.querySelector('title');
assert.exists(title);
```

Your project should have a title of `Ferris Wheel`.

```js
const title = document.querySelector('title');
assert.strictEqual(title?.text?.trim()?.toLowerCase(), 'ferris wheel');
```

Remember, the casing and spelling matter for the title.

```js
const title = document.querySelector('title');
assert.strictEqual(title?.text?.trim(), 'Ferris Wheel');
```

Your code should have a `link` element.

```js
assert.match(code, /<link/);
```

You should have one `link` element.

```js
assert.strictEqual(document.querySelectorAll('link').length, 1);
```

Your `link` element should be within your `head` element.

```js
assert.exists(document.querySelector('head > link'));
```

Your `link` element should have a `rel` attribute with the value `stylesheet`.

```js
const linkElement = document.querySelector('link');
const rel = linkElement?.getAttribute("rel");
assert.strictEqual(rel, "stylesheet");
```

Your `link` element should have an `href` attribute with the value `styles.css`.

```js
const linkElement = document.querySelector('link');
assert.strictEqual(linkElement?.dataset?.href, "styles.css");
```

# --seed--

## --seed-contents--

```html
--fcc-editable-region--

--fcc-editable-region--
```

```css

```
