---
id: 5d5a813321b9e3db6c106a46
title: Step 1
challengeType: 0
dashedName: step-1
demoType: onLoad
---

# --description--

JavaScript is a powerful language which allows you to build websites that are interactive. 

*Note*: For all remaining projects in this curriculum, you will need a basic level of knowledge in HTML and CSS. If you are new to HTML and CSS, please go through the [Responsive Web Design Certification](https://www.freecodecamp.org/learn/2022/responsive-web-design/).

To get started, create your standard HTML boilerplate with a `DOCTYPE`, `html`, `head`, and `body`, then add a `meta` tag for the `charset`. Add a `title` element and use the text `RPG - Dragon Repeller` for it. Include a `link` tag for your stylesheet to link the `styles.css` file.

Finally, create a `div` element with `id` set to `game` within your `body`.

# --hints--

Your code should contain the `DOCTYPE` reference.

```js
assert(code.match(/<!DOCTYPE/gi));
```

You should include a space after the `DOCTYPE` reference.

```js
assert(code.match(/<!DOCTYPE\s+/gi));
```

You should define the document type to be `html`.

```js
assert(code.match(/<!DOCTYPE\s+html/gi));
```

You should close the `DOCTYPE` declaration with a `>` after the type.

```js
assert(code.match(/<!DOCTYPE\s+html\s*>/gi));
```

Your `html` element should have an opening tag. Don't forget the `lang` attribute.

```js
assert(code.match(/<html\s+lang\s*=\s*('|")en\1\s*>/gi));
```

Your `html` element should have a closing tag.

```js
assert(code.match(/<\/html\s*>/));
```

Your `DOCTYPE` declaration should be at the beginning of your HTML.

```js
assert(__helpers.removeHtmlComments(code).match(/^\s*<!DOCTYPE\s+html\s*>/i));
```

You should have an opening `head` tag.

```js
assert(code.match(/<head\s*>/i));
```

You should have a closing `head` tag.

```js
assert(code.match(/<\/head\s*>/i));
```

You should have an opening `body` tag.

```js
assert(code.match(/<body\s*>/i));
```

You should have a closing `body` tag.

```js
assert(code.match(/<\/body\s*>/i));
```

The `head` and `body` elements should be siblings.

```js
assert.match(code, /<head\s*>.*<\/head\s*>.*<body\s*>.*<\/body\s*>/s)
```

The `head` element should be within the `html` element.

```js
assert.match(code, /<html[^>]*>.*<head\s*>.*<\/head\s*>.*<\/html\s*>/s);
```

The `body` element should be within the `html` element.

```js
assert.match(code, /<html[^>]*>.*<body\s*>.*<\/body\s*>.*<\/html\s*>/s);
```

Your code should have a `meta` element.

```js
const meta = document.querySelector('meta');
assert.exists(meta);
```

Your `meta` element should have a `charset` attribute with the value `UTF-8`.

```js
assert.match(code, /<meta[\s\S]+?charset=('|"|`)UTF-8\1/i)
```

Your code should have a `title` element.

```js
const title = document.querySelector('title');
assert.exists(title);
```

You should have a closing `title` tag.

```js
assert(code.match(/<\/title\s*>/i));
```

Your code should have a `link` element.

```js
const link = document.querySelector('head > link');
assert.exists(link);
```

You should have a `div` element.

```js
const div = document.querySelector('div');
assert.exists(div);
```

Your `div` element should have an `id` attribute with the value `game`.

```js
const div = document.querySelector('div');
assert.equal(div?.id, 'game');
```

Your `div` element should be within the `body` element.

```js
const div = document.querySelector('div');
assert.equal(div?.parentElement?.localName, 'body');
```

# --seed--

## --seed-contents--

```html
--fcc-editable-region--

--fcc-editable-region--
```
