---
id: 663255f28c59315db74d137b
title: Step 4
challengeType: 0
dashedName: step-4
---

# --description--

CamperBot is finished with building out the `getRandomIndex` function and it is working as expected. 

But now they are running into this issue when trying to create a reference to the `body` element in the DOM:

```js
Uncaught TypeError: document.queryselector is not a function
```

A `TypeError` means that the code is trying to perform an operation on a value that is not of the expected type. 

Fix the `TypeError` by updating the `document.queryselector` method to the correct method name that selects an element from the DOM. 

# --hints--

You should update `queryselector` to use camel case.

```js
assert.match(code, /querySelector/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Build a random background color changer</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <h1>Random Background Color changer</h1>

    <main>
      <section class="bg-information-container">
        <p>Hex Code: <span id="bg-hex-code">#110815</span></p>
      </section>

      <button class="btn" id="btn">Change Background Color</button>
    </main>
    <script src="./script.js"></script>
  </body>
</html>
```


```css
*,
*::before,
*::after {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

:root {
  --yellow: #f1be32;
  --golden-yellow: #feac32;
  --dark-purple: #110815;
  --light-grey: #efefef;
}

body {
  background-color: var(--dark-purple);
  color: var(--light-grey);
  text-align: center;
}

.bg-information-container {
  margin: 15px 0 25px;
  font-size: 1.2rem;
}

.btn {
  cursor: pointer;
  padding: 10px;
  margin: 10px;
  color: var(--dark-purple);
  background-color: var(--golden-yellow);
  background-image: linear-gradient(#fecc4c, #ffac33);
  border-color: var(--golden-yellow);
  border-width: 3px;
}

.btn:hover {
  background-image: linear-gradient(#ffcc4c, #f89808);
}

```

```js
const darkColorsArr = [
  "#2C3E50",
  "#34495E",
  "#2C2C2C",
  "#616A6B",
  "#4A235A",
  "#2F4F4F",
  "#0E4B5A",
  "#36454F",
  "#2C3E50",
  "#800020",
];
function getRandomIndex() {
  console.log(Math.floor(darkColorsArr.length * Math.random()));
  const randomIndex = Math.floor(darkColorsArr.length * Math.random());
  return randomIndex;
}

--fcc-editable-region--
const body = document.queryselector("body");
--fcc-editable-region--
```
