---
id: 6559da1b7d75f088f5e6b89f
title: Step 57
challengeType: 20
dashedName: step-57
---

# --description--

Finally, at the very end of your function, return `distances, paths`.

# --hints--

You should return `distances, paths` at the bottom of your function.

```js
({ test: () =>  {
    const shortest = __helpers.python.getDef(code, "shortest_path");
    const {function_body} = shortest;    
    assert(function_body.match(/^\s{4}return\s+distances\s*,\s*paths/m));
  }
})
```

# --seed--

## --seed-contents--

```py
my_graph = {
    'A': [('B', 3), ('D', 1)],
    'B': [('A', 3), ('C', 4)],
    'C': [('B', 4), ('D', 7)],
    'D': [('A', 1), ('C', 7)]
}

def shortest_path(graph, start, target = ''):
    unvisited = list(graph)
    distances = {node: 0 if node == start else float('inf') for node in graph}
    paths = {node: [] for node in graph}
    paths[start].append(start)
    
    while unvisited:
        current = min(unvisited, key=distances.get)
        for node, distance in graph[current]:
            if distance + distances[current] < distances[node]:
                distances[node] = distance + distances[current]
                if paths[node] and paths[node][-1] == node:
                    paths[node] = paths[current][:]
                else:
                    paths[node].extend(paths[current])
                paths[node].append(node)
        unvisited.remove(current)
--fcc-editable-region--    
    targets_to_print = [target] if target else graph
    for node in targets_to_print:
        if node == start:
            continue
        print(f'\n{start}-{node} distance: {distances[node]}\nPath: {" -> ".join(paths[node])}')
        
    
shortest_path(my_graph, 'A')
--fcc-editable-region--
```
