---
id: 6559d86fe1b8947954b9178d
title: Step 56
challengeType: 20
dashedName: step-56
---

# --description--

Now it's better but you don't want to print the details about the starting node.

Before the `print` call, add an `if` statement to execute when `node` is equal to `start` and use the `continue` keyword to go to the next loop iteration.

# --hints--

You should nest an `if` statement to check that `node` is equal to `start` inside your `for` loop.

```js
({ test: () =>  {
    const shortest = __helpers.python.getDef(code, "shortest_path");
    const {function_body} = shortest;    
    assert(function_body.match(/^(\s{4})for\s+node\s+in\s+targets_to_print\s*:\s*^\1\1if\s+(node\s*==\s*start|start\s*==\s*node)\s*:/m));
  }
})
```

You should use the `continue` keyword to go to the next iteration inside your new `if` statement.

```js
({ test: () =>  {
    const shortest = __helpers.python.getDef(code, "shortest_path");
    const {function_body} = shortest;    
    assert(function_body.match(/^(\s{4})for\s+node\s+in\s+targets_to_print\s*:\s*^\1\1if\s+(node\s*==\s*start|start\s*==\s*node)\s*:\s*^\1\1\1continue/m));

  }
})
```

# --seed--

## --seed-contents--

```py
my_graph = {
    'A': [('B', 3), ('D', 1)],
    'B': [('A', 3), ('C', 4)],
    'C': [('B', 4), ('D', 7)],
    'D': [('A', 1), ('C', 7)]
}

def shortest_path(graph, start, target = ''):
    unvisited = list(graph)
    distances = {node: 0 if node == start else float('inf') for node in graph}
    paths = {node: [] for node in graph}
    paths[start].append(start)
    
    while unvisited:
        current = min(unvisited, key=distances.get)
        for node, distance in graph[current]:
            if distance + distances[current] < distances[node]:
                distances[node] = distance + distances[current]
                if paths[node] and paths[node][-1] == node:
                    paths[node] = paths[current][:]
                else:
                    paths[node].extend(paths[current])
                paths[node].append(node)
        unvisited.remove(current)
--fcc-editable-region--  
    targets_to_print = [target] if target else graph
    for node in targets_to_print:
        print(f'\n{start}-{node} distance: {distances[node]}\nPath: {" -> ".join(paths[node])}')
    
shortest_path(my_graph, 'A')
--fcc-editable-region--
```
