---
id: 6557927ad11e58bf8c794b25
title: Step 55
challengeType: 20
dashedName: step-55
---

# --description--

Create a `for` loop to iterate over `targets_to_print` and print the following f-string: `f'\n{start}-{node} distance: {distances[node]}\nPath: {" -> ".join(paths[node])}'`.

# --hints--

You should create a `for` loop to iterate over `targets_to_print`. Use `node` as the loop variable.

```js
({ test: () =>  {
    const shortest = __helpers.python.getDef(code, "shortest_path");
    const {function_body} = shortest;    
    assert(function_body.match(/^(\s{4})for\s+node\s+in\s+targets_to_print\s*:/m));
  }
})
```

You should print the provided string inside your new `for` loop.

```js
({ test: () =>  {
    const shortest = __helpers.python.getDef(code, "shortest_path");
    const {function_body} = shortest;    
    assert(function_body.match(/^(\s{4})for\s+node\s+in\s+targets_to_print\s*:\s*^\1\1print\s*\(\s*f("|')\\n\{\s*start\s*\}-\{\s*node\s*\}\sdistance:\s\{\s*distances\s*\[\s*node\s*\]\s*\}\\nPath:\s\{\s*(?=[^\1])("|')\s->\s\3\.join\s*\(\s*paths\s*\[\s*node\s*\]\s*\)\s*\}\2\s*\)/ms));
  }
})
```

# --seed--

## --seed-contents--

```py

my_graph = {
    'A': [('B', 3), ('D', 1)],
    'B': [('A', 3), ('C', 4)],
    'C': [('B', 4), ('D', 7)],
    'D': [('A', 1), ('C', 7)]
}

def shortest_path(graph, start, target = ''):
    unvisited = list(graph)
    distances = {node: 0 if node == start else float('inf') for node in graph}
    paths = {node: [] for node in graph}
    paths[start].append(start)
    
    while unvisited:
        current = min(unvisited, key=distances.get)
        for node, distance in graph[current]:
            if distance + distances[current] < distances[node]:
                distances[node] = distance + distances[current]
                if paths[node] and paths[node][-1] == node:
                    paths[node] = paths[current][:]
                else:
                    paths[node].extend(paths[current])
                paths[node].append(node)
        unvisited.remove(current)
--fcc-editable-region--    
    targets_to_print = [target] if target else graph


shortest_path(my_graph, 'A')
--fcc-editable-region--
```
