---
id: 63507e4562cdde3a28e8de1b
title: Step 7
challengeType: 0
dashedName: step-7
---

# --description--

Much like the `.map()` method, the `.filter()` method takes a callback function. The callback function takes the current element as its first argument.

```js
array.filter(el => {

})
```

The callback function needs to return a Boolean value, which indicates whether the element should be included in the new array. In this case, you want to return `true` if the element is not `NaN` (not a number).

However, you cannot check for equality here, because `NaN` is not equal to itself. Instead, you can use the `isNaN()` method, which returns `true` if the argument is `NaN`.

Add a callback function to your `.filter()` method with `el` as its parameter, and use an implicit return to return `true` if the element is NOT `NaN`.

# --hints--

Your `.filter()` method should have a callback which accepts `el` as a parameter.

```js
assert.match(calculate.toString(), /numbers\.filter\(\s*(\(\s*el\s*\)|el)\s*=>|numbers\.filter\(\s*function\s*\(\s*el\s*\)\s*\{/)
```

Your callback function should use `!` and `isNaN()` to check if `el` is NOT `NaN`.

```js
assert.match(calculate.toString(), /!\s*(Number\.)?isNaN\(\s*el\s*\)/);
```

Your callback function should return elements that are not `NaN`.

```js
assert.match(calculate.toString(), /(numbers\.filter\(\s*(\(\s*el\s*\)|el)\s*=>|numbers\.filter\(\s*function\s*\(\s*el\s*\)\s*\{)\s*(return\s*)?!(Number\.)?isNaN\(\s*el\s*\)/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <script src="./script.js"></script>
    <title>Statistics Calculator</title>
  </head>
  <body>
    <h1>Statistics Calculator</h1>
    <p>Enter a list of comma-separated numbers.</p>

    <form onsubmit="calculate();">
      <label for="numbers">Numbers:</label>
      <input type="text" name="numbers" id="numbers" />
      <button type="submit">Calculate</button>
    </form>
    <div class="results">
      <p>
        The <dfn>mean</dfn> of a list of numbers is the average, calculated by
        taking the sum of all numbers and dividing that by the count of numbers.
      </p>
      <p class="bold">Mean: <span id="mean"></span></p>
      <p>
        The <dfn>median</dfn> of a list of numbers is the number that appears in
        the middle of the list, when sorted from least to greatest.
      </p>
      <p class="bold">Median: <span id="median"></span></p>
      <p>
        The <dfn>mode</dfn> of a list of numbers is the number that appears most
        often in the list.
      </p>
      <p class="bold">Mode: <span id="mode"></span></p>
      <p>
        The <dfn>range</dfn> of a list of numbers is the difference between the
        largest and smallest numbers in the list.
      </p>
      <p class="bold">Range: <span id="range"></span></p>
      <p>
        The <dfn>variance</dfn> of a list of numbers measures how far the values
        are from the mean, on average.
      </p>
      <p class="bold">Variance: <span id="variance"></span></p>
      <p>
        The <dfn>standard deviation</dfn> of a list of numbers is the square
        root of the variance.
      </p>
      <p class="bold">
        Standard Deviation: <span id="standardDeviation"></span>
      </p>
    </div>
  </body>
</html>
```

```css
body {
  margin: 0;
  background-color: rgb(27, 27, 50);
  text-align: center;
  color: #fff;
}

button {
  cursor: pointer;
  background-color: rgb(59, 59, 79);
  border: 3px solid white;
  color: white;
}

input {
  background-color: rgb(10, 10, 35);
  color: white;
  border: 1px solid rgb(59, 59, 79);
}

.bold {
  font-weight: bold;
}
```

```js
--fcc-editable-region--
const calculate = () => {
  const value = document.querySelector("#numbers").value;
  const array = value.split(/,\s*/g);
  const numbers = array.map(el => Number(el));
  const filtered = numbers.filter();
}
--fcc-editable-region--
```
