---
id: 669e81368e52b3a5c35a2dc5
title: Build a Video Compilation Page
challengeType: 25
dashedName: build-a-video-compilation-page
demoType: onClick
---

# --description--

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should have a `main` element as the only child of the `body` element.
1. You should have an `h1` element with the topic of your page.
1. You should have a paragraph introducing the topic of your page below your `h1` element.
1. You should have three `section` elements below your first paragraph.
1. Each section should contain an `h2` element, a paragraph, and an `iframe` element, in this order.
1. The three `iframe` elements should have a `src` attribute set to a valid video.
1. Each `iframe` element should also have a `title` attribute to describe the embedded content, and a `height` attribute and a `width` attribute to set the element to a proper size.

# --hints--

You should have a `main` element inside your `body` element.

```js
assert.equal(document.querySelector('body :first-child').tagName, 'MAIN');
```

Your `main` element should be the only child of the `body` element.

```js
assert.equal(document.querySelector('body').children.length, 1);
```

You should have an `h1` element with the topic of your page inside the `main` element.

```js
assert.isAbove(document.querySelector('h1')?.innerText.length, 0);
```

You should have a paragraph introducing the topic of your page below your `h1` element.

```js
const p = document.querySelectorAll('p')[0];
assert.equal(p?.previousElementSibling?.tagName, 'H1');
assert.isAbove(p?.innerText.length, 0);
```

You should have three `section` elements below your first `p` element.

```js
assert.equal(document.querySelectorAll('section')?.length, 3);
assert.equal(document.querySelectorAll('section')[0]?.previousElementSibling?.tagName, 'P')
```

Each `section` element should start with an `h2` element that serves as the title for that section.

```js
const sections = document.querySelectorAll('section');
assert.equal(sections?.length, 3)
for (let section of sections) {
    assert.equal(section.children[0]?.tagName, 'H2');
    assert.isAbove(section.children[0]?.innerText.length, 0);
}
```

Each `section` element should contain a `p` element to introduce the video content as its second child.

```js
const sections = document.querySelectorAll('section');
assert.equal(sections?.length, 3)
for (let section of sections) {
    assert.equal(section.children[1]?.tagName, 'P');
    assert.isAbove(section.children[1]?.innerText.length, 0);
}
```

Each `section` element should contain an `iframe` element as its third child.

```js
const sections = document.querySelectorAll('section');
assert.equal(sections?.length, 3)
for (let section of sections) {
    assert.equal(section.children[2]?.tagName, 'IFRAME');
}
```

Your first `iframe` element should have a `src` attribute set to a valid video.

```js
assert.isAbove(document.querySelectorAll('iframe')[0]?.src.length, 0)
```

Your first `iframe` element should have a `title` attribute to describe the embedded content.

```js
assert.isAbove(document.querySelectorAll('iframe')[0]?.title.length, 0)
```

Your first `iframe` element should have a `height` attribute.

```js
assert.isAbove(document.querySelectorAll('iframe')[0]?.height.length, 0)
```

Your first `iframe` element should have a `width` attribute.

```js
assert.isAbove(document.querySelectorAll('iframe')[0]?.width.length, 0)
```

Your second `iframe` element should have a `src` attribute set to a valid video.

```js
assert.isAbove(document.querySelectorAll('iframe')[1]?.src.length, 0)
```

Your second `iframe` element should have a `title` attribute to describe the embedded content.

```js
assert.isAbove(document.querySelectorAll('iframe')[1]?.title.length, 0)
```

Your second `iframe` element should have a `height` attribute.

```js
assert.isAbove(document.querySelectorAll('iframe')[1]?.height.length, 0)
```

Your second `iframe` element should have a `width` attribute.

```js
assert.isAbove(document.querySelectorAll('iframe')[1]?.width.length, 0)
```

Your third `iframe` element should have a `src` attribute set to a valid video.

```js
assert.isAbove(document.querySelectorAll('iframe')[2]?.src.length, 0)
```

Your third `iframe` element should have a `title` attribute to describe the embedded content.

```js
assert.isAbove(document.querySelectorAll('iframe')[2]?.title.length, 0)
```

Your third `iframe` element should have a `height` attribute.

```js
assert.isAbove(document.querySelectorAll('iframe')[2]?.height.length, 0)
```

Your third `iframe` element should have a `width` attribute.

```js
assert.isAbove(document.querySelectorAll('iframe')[2]?.width.length, 0)
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Video Compilation Page</title>
</head>

<body>

</body>

</html>
```

# --solutions--

```html
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Video Compilation Page</title>
</head>

<body>
    <main>
        <h1>Front End Web Development</h1>
        <p>Front End Web Development involves designing and building user interfaces of websites using HTML, CSS, and
            JavaScript. It focuses on creating visually appealing, interactive, and user-friendly websites. Front End
            developers
            ensure accessibility, performance optimization, and
            adherence to web standards, blending creativity with technical expertise.</p>
        <section>
            <h2>HTML</h2>
            <p>HTML, or HyperText Markup Language, forms the backbone of web pages by defining their basic structure and
                layout. It uses a series of elements to display text, images, lists, tables, and other static content on
                a web page.</p>
            <iframe width="560" height="315" src="https://www.youtube.com/embed/GDGejH3SDNQ?si=KJYLgcz4kyyroYMB"
                title="html and coding introduction video" frameborder="0"
                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
        </section>
        <section>
            <h2>CSS</h2>
            <p>CSS, or Cascading Style Sheets, is used to control the visual presentation of HTML elements on a web
                page. It allows for customized styling, including colors, fonts, layouts, and spacing, making websites
                visually appealing. CSS also supports responsive design, ensuring web pages look good on
                all devices.</p>
            <iframe width="560" height="315" src="https://www.youtube.com/embed/OXGznpKZ_sA?si=s3KDSZvrhU_PU9XL"
                title="css tutorial video" frameborder="0"
                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
        </section>
        <section>
            <h2>JavaScript</h2>
            <p>JavaScript is a programming language that adds interactivity to static web pages, enabling dynamic
                content updates, form validations, animations, and responsive behaviors based on user interactions and
                events.</p>
            <iframe width="560" height="315" src="https://www.youtube.com/embed/jS4aFq5-91M?si=zKQhHEYwU4tnMmVm"
                title="javascript programming video" frameborder="0"
                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
        </section>
    </main>
</body>

</html>
```
