---
id: 587d78b0367417b2b2512b05
title: Build a Technical Documentation Page
challengeType: 25
demoType: onClick
dashedName: build-a-technical-documentation-page
saveSubmissionToDB: true
---

# --description--

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You can see a `main` element with a corresponding `id="main-doc"`, which contains the page's main content (technical documentation).
1. Within the `#main-doc` element, you can see several `section` elements, each with a class of `main-section`. There should be a minimum of five.
1. The first element within each `.main-section` should be a `header` element, which contains text that describes the topic of that section.
1. Each `section` element with the class of `main-section` should also have an `id` that corresponds with the text of each `header` contained within it. Any spaces should be replaced with underscores (e.g. The section that contains the header "JavaScript and Java" should have a corresponding `id="JavaScript_and_Java"`).
1. The `.main-section` elements should contain at least ten `p` elements total (not each).
1. The `.main-section` elements should contain at least five `code` elements total (not each).
1. The `.main-section` elements should contain at least five `li` items total (not each).
1. You can see a `nav` element with a corresponding `id="navbar"`.
1. The navbar element should contain one `header` element which contains text that describes the topic of the technical documentation.
1. Additionally, the navbar should contain link (`a`) elements with the class of `nav-link`. There should be one for every element with the class `main-section`.
1. The `header` element in the `#navbar` must come before any link (`a`) elements in the navbar.
1. Each element with the class of `nav-link` should contain text that corresponds to the `header` text within each `section` (e.g. if you have a "Hello world" section/header, your navbar should have an element which contains the text "Hello world").
1. When you click on a navbar element, the page should navigate to the corresponding section of the `#main-doc` element (e.g. If you click on a `.nav-link` element that contains the text "Hello world", the page navigates to a `section` element with that id, and contains the corresponding header).
1. On regular sized devices (laptops, desktops), the element with `id="navbar"` should be shown on the left side of the screen and should always be visible to the user.
1. Your technical documentation should use at least one media query.

**Note:** Be sure to link your stylesheet in your HTML and apply your CSS.

# --hints--

You should have a `main` element with an `id` of `main-doc`.

```js
const el = document.getElementById('main-doc');
assert.isNotNull(el);
```

You should have at least five `section` elements with a class of `main-section`.

```js
const els = document.querySelectorAll('#main-doc section');
assert.isAtLeast(els.length, 5);
```

All of your `.main-section` elements should be `section` elements.

```js
const els = document.querySelectorAll('.main-section');
els.forEach(el => {
  if (el.tagName !== 'SECTION') {
    assert.fail();
  }
});
assert.isAbove(els.length, 0);
```

You should have at least five `.main-section` elements that are descendants of `#main-doc`.

```js
const els = document.querySelectorAll('#main-doc .main-section');
assert.isAtLeast(els.length, 5);
```

The first child of each `.main-section` should be a `header` element.

```js
const els = document.querySelectorAll('.main-section');
els.forEach(el => {
  if (el.firstElementChild?.tagName !== 'HEADER') assert.fail();
});
assert.isNotEmpty(els);
```

None of your `header` elements should be empty.

```js
const els = document.querySelectorAll('header');
els.forEach(el => {
  if (el.innerText?.length <= 0) assert.fail();
});
assert.isNotEmpty(els);
```

All of your `.main-section` elements should have an `id`.

```js
const els = document.querySelectorAll('.main-section');
els.forEach(el => {
  if (!el.id || el.id === '') assert.fail();
});
assert.isNotEmpty(els);
```

Each `.main-section` should have an `id` that matches the text of its first child, having any spaces in the child's text replaced with underscores (`_`) for the id's.

```js
const els = document.querySelectorAll('.main-section');
els.forEach(el => {
  const text = el.firstElementChild?.innerText?.replaceAll(' ', '_');
  if (el.id?.toUpperCase() !== text?.toUpperCase()) assert.fail();
});
assert.isNotEmpty(els);
```

You should have at least 10 `p` elements (total) within your `.main-section` elements.

```js
const els = document.querySelectorAll('.main-section p');
assert.isAtLeast(els.length, 10);
```

You should have at least five `code` elements that are descendants of `.main-section` elements.

```js
const els = document.querySelectorAll('.main-section code');
assert.isAtLeast(els.length, 5);
```

You should have at least five `li` elements that are descendants of `.main-section` elements.

```js
const els = document.querySelectorAll('.main-section li');
assert.isAtLeast(els.length, 5);
```

You should have a `nav` element with an `id` of `navbar`.

```js
const el = document.getElementById('navbar');
assert.isNotNull(el);
assert.strictEqual(el.tagName, 'NAV');
```

Your `#navbar` should have exactly one `header` element within it.

```js
const els = document.querySelectorAll('#navbar header');
assert.lengthOf(els, 1);
```

You should have at least one `a` element with a class of `nav-link`.

```js
const els = document.querySelectorAll('a.nav-link');
assert.isAtLeast(els.length, 1);
```

All of your `.nav-link` elements should be anchor (`a`) elements.

```js
const els = document.querySelectorAll('.nav-link');
els.forEach(el => {
  if (el.tagName !== 'A') assert.fail();
});
assert.isNotEmpty(els);
```

All of your `.nav-link` elements should be in the `#navbar`.

```js
const els1 = document.querySelectorAll('.nav-link');
const els2 = document.querySelectorAll('#navbar .nav-link');
assert.isNotEmpty(els2);
assert.strictEqual(els1.length, els2.length);
```

You should have the same number of `.nav-link` and `.main-section` elements.

```js
const els1 = document.querySelectorAll('.main-section');
const els2 = document.querySelectorAll('.nav-link');
assert.isNotEmpty(els1);
assert.isNotEmpty(els2);
assert.strictEqual(els1.length, els2.length);
```

The `header` element in the `#navbar` should come before any link (`a`) elements also in the `#navbar`.

```js
const navLinks = document.querySelectorAll('#navbar a.nav-link');
const header = document.querySelector('#navbar header');
navLinks.forEach(navLink => {
  if (
    header.compareDocumentPosition(navLink) & Node.DOCUMENT_POSITION_PRECEDING
  )
    assert.fail();
});
assert.isNotNull(header);
```

Each `.nav-link` should have text that corresponds to the `header` text of its related `section` (e.g. if you have a "Hello world" section/header, your `#navbar` should have a `.nav-link` which has the text "Hello world").

```js
const headerText = Array.from(document.querySelectorAll('.main-section')).map(
  el => el.firstElementChild?.innerText?.trim().toUpperCase()
);
const linkText = Array.from(document.querySelectorAll('.nav-link')).map(el =>
  el.innerText?.trim().toUpperCase()
);
const remainder = headerText.filter(str => linkText.indexOf(str) === -1);

assert.isNotEmpty(headerText);
assert.isNotEmpty(linkText);
assert.isEmpty(remainder);
```

Each `.nav-link` should have an `href` attribute that links to its corresponding `.main-section` (e.g. If you click on a `.nav-link` element that contains the text "Hello world", the page navigates to a `section` element with that id).

```js
const hrefValues = Array.from(document.querySelectorAll('.nav-link')).map(el =>
  el.getAttribute('href')
);
const mainSectionIDs = Array.from(
  document.querySelectorAll('.main-section')
).map(el => el.id);
const missingHrefValues = mainSectionIDs.filter(
  str => hrefValues.indexOf('#' + str) === -1
);
assert.isNotEmpty(hrefValues);
assert.isNotEmpty(mainSectionIDs);
assert.isEmpty(missingHrefValues, 0);
```

Your `#navbar` should always be on the left edge of the window.

```js
const el = document.getElementById('navbar');
const left1 = el?.offsetLeft;
assert.isNotNull(el);
assert.isAtLeast(left1, -15);
assert.isAtMost(left1, 15);
```

Your Technical Documentation project should use at least one media query.

```js
const htmlSourceAttr = Array.from(document.querySelectorAll('source')).map(el =>
  el.getAttribute('media')
);
const cssCheck = new __helpers.CSSHelp(document).getCSSRules('media');
assert.isTrue(cssCheck.length > 0 || htmlSourceAttr.length > 0);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <title>Technical Documentation Page</title>
  </head>

  <body>
  
  </body>
</html>
```

```css

```

# --solutions--

```html
<!DOCTYPE html>
<html>
  <head>
    <link rel="stylesheet" href="styles.css" />
  </head>
  <body>
    <nav id="navbar">
      <header>JS Documentation</header>
      <ul>
        <li><a class="nav-link" href="#Introduction">Introduction</a></li>
        <li>
          <a class="nav-link" href="#What_you_should_already_know"
            >What you should already know</a
          >
        </li>
        <li>
          <a class="nav-link" href="#JavaScript_and_Java"
            >JavaScript and Java</a
          >
        </li>
        <li><a class="nav-link" href="#Hello_world">Hello world</a></li>
        <li><a class="nav-link" href="#Variables">Variables</a></li>
        <li>
          <a class="nav-link" href="#Declaring_variables"
            >Declaring variables</a
          >
        </li>
        <li><a class="nav-link" href="#Variable_scope">Variable scope</a></li>
        <li>
          <a class="nav-link" href="#Global_variables">Global variables</a>
        </li>
        <li><a class="nav-link" href="#Constants">Constants</a></li>
        <li><a class="nav-link" href="#Data_types">Data types</a></li>
        <li>
          <a class="nav-link" href="#if...else_statement"
            >if...else statement</a
          >
        </li>
        <li><a class="nav-link" href="#while_statement">while statement</a></li>
        <li>
          <a class="nav-link" href="#Function_declarations"
            >Function declarations</a
          >
        </li>
        <li><a class="nav-link" href="#Reference">Reference</a></li>
      </ul>
    </nav>
    <main id="main-doc">
      <section class="main-section" id="Introduction">
        <header>Introduction</header>
        <article>
          <p>
            JavaScript is a cross-platform, object-oriented scripting language.
            It is a small and lightweight language. Inside a host environment
            (for example, a web browser), JavaScript can be connected to the
            objects of its environment to provide programmatic control over
            them.
          </p>

          <p>
            JavaScript contains a standard library of objects, such as Array,
            Date, and Math, and a core set of language elements such as
            operators, control structures, and statements. Core JavaScript can
            be extended for a variety of purposes by supplementing it with
            additional objects; for example:
          </p>
          <ul>
            <li>
              Client-side JavaScript extends the core language by supplying
              objects to control a browser and its Document Object Model (DOM).
              For example, client-side extensions allow an application to place
              elements on an HTML form and respond to user events such as mouse
              clicks, form input, and page navigation.
            </li>
            <li>
              Server-side JavaScript extends the core language by supplying
              objects relevant to running JavaScript on a server. For example,
              server-side extensions allow an application to communicate with a
              database, provide continuity of information from one invocation to
              another of the application, or perform file manipulations on a
              server.
            </li>
          </ul>
        </article>
      </section>
      <section class="main-section" id="What_you_should_already_know">
        <header>What you should already know</header>
        <article>
          <p>This guide assumes you have the following basic background:</p>

          <ul>
            <li>
              A general understanding of the Internet and the World Wide Web
              (WWW).
            </li>
            <li>Good working knowledge of HyperText Markup Language (HTML).</li>
            <li>
              Some programming experience. If you are new to programming, try
              one of the tutorials linked on the main page about JavaScript.
            </li>
          </ul>
        </article>
      </section>
      <section class="main-section" id="JavaScript_and_Java">
        <header>JavaScript and Java</header>
        <article>
          <p>
            JavaScript and Java are similar in some ways but fundamentally
            different in some others. The JavaScript language resembles Java but
            does not have Java's static typing and strong type checking.
            JavaScript follows most Java expression syntax, naming conventions
            and basic control-flow constructs which was the reason why it was
            renamed from LiveScript to JavaScript.
          </p>

          <p>
            In contrast to Java's compile-time system of classes built by
            declarations, JavaScript supports a runtime system based on a small
            number of data types representing numeric, Boolean, and string
            values. JavaScript has a prototype-based object model instead of the
            more common class-based object model. The prototype-based model
            provides dynamic inheritance; that is, what is inherited can vary
            for individual objects. JavaScript also supports functions without
            any special declarative requirements. Functions can be properties of
            objects, executing as loosely typed methods.
          </p>
          <p>
            JavaScript is a very free-form language compared to Java. You do not
            have to declare all variables, classes, and methods. You do not have
            to be concerned with whether methods are public, private, or
            protected, and you do not have to implement interfaces. Variables,
            parameters, and function return types are not explicitly typed.
          </p>
        </article>
      </section>
      <section class="main-section" id="Hello_world">
        <header>Hello world</header>
        <article>
          To get started with writing JavaScript, open the Scratchpad and write
          your first "Hello world" JavaScript code:
          <code
            >function greetMe(yourName) { alert("Hello " + yourName); }
            greetMe("World");
          </code>

          Select the code in the pad and hit Ctrl+R to watch it unfold in your
          browser!
        </article>
      </section>
      <section class="main-section" id="Variables">
        <header>Variables</header>
        <p>
          You use variables as symbolic names for values in your application.
          The names of variables, called identifiers, conform to certain rules.
        </p>
        <p>
          A JavaScript identifier must start with a letter, underscore (_), or
          dollar sign ($); subsequent characters can also be digits (0-9).
          Because JavaScript is case sensitive, letters include the characters
          "A" through "Z" (uppercase) and the characters "a" through "z"
          (lowercase).
        </p>
        <p>
          You can use ISO 8859-1 or Unicode letters such as å and ü in
          identifiers. You can also use the Unicode escape sequences as
          characters in identifiers. Some examples of legal names are
          Number_hits, temp99, and _name.
        </p>
      </section>
      <section class="main-section" id="Declaring_variables">
        <header>Declaring variables</header>
        <article>
          You can declare a variable in three ways:
          <p>
            With the keyword var. For example, <code>var x = 42.</code> This
            syntax can be used to declare both local and global variables.
          </p>
          <p>
            By simply assigning it a value. For example,
            <code>x = 42.</code> This always declares a global variable. It
            generates a strict JavaScript warning. You shouldn't use this
            variant.
          </p>
          <p>
            With the keyword let. For example,<code> let y = 13.</code> This
            syntax can be used to declare a block scope local variable. See
            Variable scope below.
          </p>
        </article>
      </section>
      <section class="main-section" id="Variable_scope">
        <header>Variable scope</header>
        <article>
          <p>
            When you declare a variable outside of any function, it is called a
            global variable, because it is available to any other code in the
            current document. When you declare a variable within a function, it
            is called a local variable, because it is available only within that
            function.
          </p>

          <p>
            JavaScript before ECMAScript 2015 does not have block statement
            scope; rather, a variable declared within a block is local to the
            function (or global scope) that the block resides within. For
            example the following code will log 5, because the scope of x is the
            function (or global context) within which x is declared, not the
            block, which in this case is an if statement.
          </p>
          <code>if (true) { var x = 5; } console.log(x); // 5</code>
          <p>
            This behavior changes, when using the let declaration introduced in
            ECMAScript 2015.
          </p>

          <code
            >if (true) { let y = 5; } console.log(y); // ReferenceError: y is
            not defined</code
          >
        </article>
      </section>
      <section class="main-section" id="Global_variables">
        <header>Global variables</header>
        <article>
          <p>
            Global variables are in fact properties of the global object. In web
            pages the global object is window, so you can set and access global
            variables using the window.variable syntax.
          </p>

          <p>
            Consequently, you can access global variables declared in one window
            or frame from another window or frame by specifying the window or
            frame name. For example, if a variable called phoneNumber is
            declared in a document, you can refer to this variable from an
            iframe as parent.phoneNumber.
          </p>
        </article>
      </section>
      <section class="main-section" id="Constants">
        <header>Constants</header>
        <article>
          <p>
            You can create a read-only, named constant with the const keyword.
            The syntax of a constant identifier is the same as for a variable
            identifier: it must start with a letter, underscore or dollar sign
            and can contain alphabetic, numeric, or underscore characters.
          </p>

          <code>const PI = 3.14;</code>
          <p>
            A constant cannot change value through assignment or be re-declared
            while the script is running. It has to be initialized to a value.
          </p>

          <p>
            The scope rules for constants are the same as those for let block
            scope variables. If the const keyword is omitted, the identifier is
            assumed to represent a variable.
          </p>

          <p>
            You cannot declare a constant with the same name as a function or
            variable in the same scope. For example:
          </p>

          <code
            >// THIS WILL CAUSE AN ERROR function f() {}; const f = 5; // THIS
            WILL CAUSE AN ERROR ALSO function f() { const g = 5; var g;
            //statements }</code
          >
          However, object attributes are not protected, so the following
          statement is executed without problems.
          <code
            >const MY_OBJECT = {"key": "value"}; MY_OBJECT.key =
            "otherValue";</code
          >
        </article>
      </section>
      <section class="main-section" id="Data_types">
        <header>Data types</header>
        <article>
          <p>The latest ECMAScript standard defines seven data types:</p>
          <ul>
            <li>
              <p>Six data types that are primitives:</p>
              <ul>
                <li>Boolean. true and false.</li>
                <li>
                  null. A special keyword denoting a null value. Because
                  JavaScript is case-sensitive, null is not the same as Null,
                  NULL, or any other variant.
                </li>
                <li>
                  undefined. A top-level property whose value is undefined.
                </li>
                <li>Number. 42 or 3.14159.</li>
                <li>String. "Howdy"</li>
                <li>
                  Symbol (new in ECMAScript 2015). A data type whose instances
                  are unique and immutable.
                </li>
              </ul>
            </li>

            <li>and Object</li>
          </ul>
          Although these data types are a relatively small amount, they enable
          you to perform useful functions with your applications. Objects and
          functions are the other fundamental elements in the language. You can
          think of objects as named containers for values, and functions as
          procedures that your application can perform.
        </article>
      </section>
      <section class="main-section" id="if...else_statement">
        <header>if...else statement</header>
        <article>
          Use the if statement to execute a statement if a logical condition is
          true. Use the optional else clause to execute a statement if the
          condition is false. An if statement looks as follows:

          <code>if (condition) { statement_1; } else { statement_2; }</code>
          condition can be any expression that evaluates to true or false. See
          Boolean for an explanation of what evaluates to true and false. If
          condition evaluates to true, statement_1 is executed; otherwise,
          statement_2 is executed. statement_1 and statement_2 can be any
          statement, including further nested if statements.
          <p>
            You may also compound the statements using else if to have multiple
            conditions tested in sequence, as follows:
          </p>
          <code
            >if (condition_1) { statement_1; } else if (condition_2) {
            statement_2; } else if (condition_n) { statement_n; } else {
            statement_last; }
          </code>
          In the case of multiple conditions only the first logical condition
          which evaluates to true will be executed. To execute multiple
          statements, group them within a block statement ({ ... }) . In
          general, it's good practice to always use block statements, especially
          when nesting if statements:

          <code
            >if (condition) { statement_1_runs_if_condition_is_true;
            statement_2_runs_if_condition_is_true; } else {
            statement_3_runs_if_condition_is_false;
            statement_4_runs_if_condition_is_false; }</code
          >
          It is advisable to not use simple assignments in a conditional
          expression, because the assignment can be confused with equality when
          glancing over the code. For example, do not use the following code:
          <code>if (x = y) { /* statements here */ }</code> If you need to use
          an assignment in a conditional expression, a common practice is to put
          additional parentheses around the assignment. For example:

          <code>if ((x = y)) { /* statements here */ }</code>
        </article>
      </section>
      <section class="main-section" id="while_statement">
        <header>while statement</header>
        <article>
          A while statement executes its statements as long as a specified
          condition evaluates to true. A while statement looks as follows:

          <code>while (condition) statement</code> If the condition becomes
          false, statement within the loop stops executing and control passes to
          the statement following the loop.

          <p>
            The condition test occurs before statement in the loop is executed.
            If the condition returns true, statement is executed and the
            condition is tested again. If the condition returns false, execution
            stops and control is passed to the statement following while.
          </p>

          <p>
            To execute multiple statements, use a block statement ({ ... }) to
            group those statements.
          </p>

          Example:

          <p>
            The following while loop iterates as long as n is less than three:
          </p>

          <code>var n = 0; var x = 0; while (n &lt; 3) { n++; x += n; }</code>
          <p>
            With each iteration, the loop increments n and adds that value to x.
            Therefore, x and n take on the following values:
          </p>

          <ul>
            <li>After the first pass: n = 1 and x = 1</li>
            <li>After the second pass: n = 2 and x = 3</li>
            <li>After the third pass: n = 3 and x = 6</li>
          </ul>
          <p>
            After completing the third pass, the condition n &lt; 3 is no longer
            true, so the loop terminates.
          </p>
        </article>
      </section>
      <section class="main-section" id="Function_declarations">
        <header>Function declarations</header>
        <article>
          A function definition (also called a function declaration, or function
          statement) consists of the function keyword, followed by:

          <ul>
            <li>The name of the function.</li>
            <li>
              A list of arguments to the function, enclosed in parentheses and
              separated by commas.
            </li>
            <li>
              The JavaScript statements that define the function, enclosed in
              curly brackets, { }.
            </li>
          </ul>
          <p>
            For example, the following code defines a simple function named
            square:
          </p>

          <code>function square(number) { return number * number; }</code>
          <p>
            The function square takes one argument, called number. The function
            consists of one statement that says to return the argument of the
            function (that is, number) multiplied by itself. The return
            statement specifies the value returned by the function.
          </p>
          <code>return number * number;</code>
          <p>
            Primitive parameters (such as a number) are passed to functions by
            value; the value is passed to the function, but if the function
            changes the value of the parameter, this change is not reflected
            globally or in the calling function.
          </p>
        </article>
      </section>
      <section class="main-section" id="Reference">
        <header>Reference</header>
        <article>
          <ul>
            <li>
              All the documentation in this page is taken from
              <a
                href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide"
                target="_blank"
                >MDN</a
              >
            </li>
          </ul>
        </article>
      </section>
    </main>
  </body>
</html>
```

```css
html,
body {
  min-width: 290px;
  color: #4d4e53;
  background-color: #ffffff;
  font-family: 'Open Sans', Arial, sans-serif;
  line-height: 1.5;
}

#navbar {
  position: fixed;
  min-width: 290px;
  top: 0px;
  left: 0px;
  width: 300px;
  height: 100%;
  border-right: solid;
  border-color: rgba(0, 22, 22, 0.4);
}

header {
  color: black;
  margin: 10px;
  text-align: center;
  font-size: 1.8em;
  font-weight: thin;
}

#main-doc header {
  text-align: left;
  margin: 0px;
}

#navbar ul {
  height: 88%;
  padding: 0;
  overflow-y: auto;
  overflow-x: hidden;
}

#navbar li {
  color: #4d4e53;
  border-top: 1px solid;
  list-style: none;
  position: relative;
  width: 100%;
}

#navbar a {
  display: block;
  padding: 10px 30px;
  color: #4d4e53;
  text-decoration: none;
  cursor: pointer;
}

#main-doc {
  position: absolute;
  margin-left: 310px;
  padding: 20px;
  margin-bottom: 110px;
}

section article {
  color: #4d4e53;
  margin: 15px;
  font-size: 0.96em;
}

section li {
  margin: 15px 0px 0px 20px;
}

code {
  display: block;
  text-align: left;
  white-space: pre-line;
  position: relative;
  word-break: normal;
  word-wrap: normal;
  line-height: 2;
  background-color: #f7f7f7;
  padding: 15px;
  margin: 10px;
  border-radius: 5px;
}

@media only screen and (max-width: 815px) {
  /* For mobile phones: */
  #navbar ul {
    border: 1px solid;
    height: 207px;
  }

  #navbar {
    background-color: white;
    position: absolute;
    top: 0;
    padding: 0;
    margin: 0;
    width: 100%;
    max-height: 275px;
    border: none;
    z-index: 1;
    border-bottom: 2px solid;
  }

  #main-doc {
    position: relative;
    margin-left: 0px;
    margin-top: 270px;
  }
}

@media only screen and (max-width: 400px) {
  #main-doc {
    margin-left: -10px;
  }

  code {
    margin-left: -20px;
    width: 100%;
    padding: 15px;
    padding-left: 10px;
    padding-right: 45px;
    min-width: 233px;
  }
}
```
