---
id: 587d78af367417b2b2512b03
title: Build a Survey Form
challengeType: 25
dashedName: build-a-survey-form
demoType: onClick
saveSubmissionToDB: true
---

# --description--

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should have a page title in an `h1` element with an `id` of `title`.
1. You should have a short explanation in a `p` element with an `id` of `description`.
1. You should have a `form` element with an `id` of `survey-form`.
1. Inside the form element you should have a required `input` field to enter your name that has an `id` of `name` and a `type` of `text`.
1. Inside the form element you should have a required `input` field to enter your email that has an `id` of `email`.
1. If you enter an email that is not formatted correctly, you should see an HTML5 validation error.
1. Inside the form element you should have an `input` field to enter a number that has an `id` of `number`.
1. The number input should not accept non-numbers, either by preventing you from typing them or by showing an HTML5 validation error (depending on your browser).
1. If you enter numbers outside the range of the number input, which are defined by the `min` and `max` attributes, you should see an HTML5 validation error.
1. For the name, email, and number input fields, you should have corresponding `label` elements in the form, that describe the purpose of each field with the following ids: `name-label`, `email-label`, and `number-label`.
1. For the name, email, and number input fields, you should have a placeholder text that gives a description or instructions for each field.
1. Inside the form element, you should have a `select` dropdown element with an `id` of `dropdown` and at least two options to choose from.
1. Inside the form element, you can select an option from a group of at least two radio buttons that are grouped using the `name` attribute.
1. Inside the form element, you can select several fields from a series of checkboxes, each of which must have a `value` attribute.
1. Inside the form element, you should have a `textarea` for additional comments.
1. Inside the form element, you should have a button with `id` of `submit` to submit all the inputs.

# --hints--

You should have an `h1` element with an `id` of `title`.

```js
const el = document.getElementById('title');
assert.isNotNull(el);
assert.strictEqual(el.tagName, 'H1');
```

Your `#title` should not be empty.

```js
const el = document.getElementById('title');
assert.isNotNull(el);
assert.isAbove(el.innerText.length, 0);
```

You should have a `p` element with an `id` of `description`.

```js
const el = document.getElementById('description');
assert.isNotNull(el);
assert.strictEqual(el.tagName, 'P');
```

Your `#description` should not be empty.

```js
const el = document.getElementById('description');
assert.isNotNull(el);
assert.isAbove(el.innerText.length, 0);
```

You should have a `form` element with an `id` of `survey-form`.

```js
const el = document.getElementById('survey-form');
assert.isNotNull(el);
assert.strictEqual(el.tagName, 'FORM');
```

You should have an `input` element with an `id` of `name`.

```js
const el = document.getElementById('name');
assert.isNotNull(el);
assert.strictEqual(el.tagName, 'INPUT');
```

Your `#name` should have a `type` of `text`.

```js
const el = document.getElementById('name');
assert.isNotNull(el);
assert.strictEqual(el.type, 'text');
```

Your `#name` should require input.

```js
const el = document.getElementById('name');
assert.isNotNull(el);
assert.isTrue(el.required);
```

Your `#name` should be a descendant of `#survey-form`.

```js
const el = document.querySelector('#survey-form #name');
assert.isNotNull(el);
```

You should have an `input` element with an `id` of `email`.

```js
const el = document.getElementById('email');
assert.isNotNull(el);
assert.strictEqual(el.tagName, 'INPUT');
```

Your `#email` should have a `type` of `email`.

```js
const el = document.getElementById('email');
assert.isNotNull(el);
assert.strictEqual(el.type, 'email');
```

Your `#email` should require input.

```js
const el = document.getElementById('email');
assert.isNotNull(el);
assert.isTrue(el.required);
```

Your `#email` should be a descendant of `#survey-form`.

```js
const el = document.querySelector('#survey-form #email');
assert.isNotNull(el);
```

You should have an `input` element with an `id` of `number`.

```js
const el = document.getElementById('number');
assert.isNotNull(el);
assert.strictEqual(el.tagName, 'INPUT');
```

Your `#number` should be a descendant of `#survey-form`.

```js
const el = document.querySelector('#survey-form #number');
assert.isNotNull(el);
```

Your `#number` should have a `type` of `number`.

```js
const el = document.getElementById('number');
assert.isNotNull(el);
assert.strictEqual(el.type, 'number');
```

Your `#number` should have a `min` attribute with a numeric value.

```js
const el = document.getElementById('number');
assert.isNotNull(el);
assert.isNotEmpty(el.min);
assert.isTrue(isFinite(el.min));
```

Your `#number` should have a `max` attribute with a numeric value.

```js
const el = document.getElementById('number');
assert.isNotNull(el);
assert.isNotEmpty(el.max);
assert.isTrue(isFinite(el.max));
```

You should have a `label` element with an `id` of `name-label`.

```js
const el = document.getElementById('name-label');
assert.isNotNull(el);
assert.strictEqual(el.tagName, 'LABEL');
```

You should have a `label` element with an `id` of `email-label`.

```js
const el = document.getElementById('email-label');
assert.isNotNull(el);
assert.strictEqual(el.tagName, 'LABEL');
```

You should have a `label` element with an `id` of `number-label`.

```js
const el = document.getElementById('number-label');
assert.isNotNull(el);
assert.strictEqual(el.tagName, 'LABEL');
```

Your `#name-label` should contain text that describes the input.

```js
const el = document.getElementById('name-label');
assert.isNotNull(el);
assert.isAbove(el.innerText.length, 0);
```

Your `#email-label` should contain text that describes the input.

```js
const el = document.getElementById('email-label');
assert.isNotNull(el);
assert.isAbove(el.innerText.length, 0);
```

Your `#number-label` should contain text that describes the input.

```js
const el = document.getElementById('number-label');
assert.isNotNull(el);
assert.isAbove(el.innerText.length, 0);
```

Your `#name-label` should be a descendant of `#survey-form`.

```js
const el = document.querySelector('#survey-form #name-label');
assert.isNotNull(el);
```

Your `#email-label` should be a descendant of `#survey-form`.

```js
const el = document.querySelector('#survey-form #email-label');
assert.isNotNull(el);
```

Your `#number-label` should be a descendant of `#survey-form`.

```js
const el = document.querySelector('#survey-form #number-label');
assert.isNotNull(el);
```

Your `#name` should have a `placeholder` attribute and value.

```js
const el = document.getElementById('name');
assert.isNotNull(el);
assert.isNotNull(el.placeholder);
assert.isAbove(el.placeholder.length, 0);
```

Your `#email` should have a `placeholder` attribute and value.

```js
const el = document.getElementById('email');
assert.isNotNull(el);
assert.isNotNull(el.placeholder);
assert.isAbove(el.placeholder.length, 0);
```

Your `#number` should have a `placeholder` attribute and value.

```js
const el = document.getElementById('number');
assert.isNotNull(el);
assert.isNotNull(el.placeholder);
assert.isAbove(el.placeholder.length, 0);
```

You should have a `select` field with an `id` of `dropdown`.

```js
const el = document.getElementById('dropdown');
assert.isNotNull(el);
assert.strictEqual(el.tagName, 'SELECT');
```

Your `#dropdown` should have at least two selectable (not disabled) `option` elements.

```js
const els = document.querySelectorAll('#dropdown option:not([disabled])');
assert.isAtLeast(els.length, 2);
```

Your `#dropdown` should be a descendant of `#survey-form`.

```js
const el = document.querySelector('#survey-form #dropdown');
assert.isNotNull(el);
```

You should have at least two `input` elements with a `type` of `radio` (radio buttons).

```js
const els = document.querySelectorAll('input[type="radio"]');
assert.isAtLeast(els.length, 2);
```

You should have at least two radio buttons that are descendants of `#survey-form`.

```js
const els = document.querySelectorAll('#survey-form input[type="radio"]');
assert.isAtLeast(els.length, 2);
```

All your radio buttons should have a `value` attribute and value.

```js
const els1 = document.querySelectorAll('input[type="radio"]');
const els2 = document.querySelectorAll(
  'input[type="radio"][value=""], input[type="radio"]:not([value])'
);
assert.isAbove(els1.length, 0);
assert.lengthOf(els2, 0);
```

All your radio buttons should have a `name` attribute and value.

```js
const els1 = document.querySelectorAll('input[type="radio"]');
const els2 = document.querySelectorAll(
  'input[type="radio"][name=""], input[type="radio"]:not([name])'
);
assert.isAbove(els1.length, 0);
assert.lengthOf(els2, 0);
```

Every radio button group should have at least 2 radio buttons.

```js
const radioButtons = document.querySelectorAll('input[type="radio"]');
const groups = {};

if (radioButtons) {
  radioButtons.forEach(el => {
    if (!groups[el.name]) groups[el.name] = [];
    groups[el.name].push(el);
  });
}

const groupKeys = Object.keys(groups);

groupKeys.forEach(key => {
  if (groups[key].length < 2) assert.fail();
});

assert.isAbove(groupKeys.length, 0);
```

You should have at least two `input` elements with a `type` of `checkbox` (checkboxes) that are descendants of `#survey-form`.

```js
const els = document.querySelectorAll('#survey-form input[type="checkbox"]');
assert.isAtLeast(els.length, 2);
```

All your checkboxes inside `#survey-form` should have a `value` attribute and value.

```js
const els1 = document.querySelectorAll('#survey-form input[type="checkbox"]');
const els2 = document.querySelectorAll(
  '#survey-form input[type="checkbox"][value=""], #survey-form input[type="checkbox"]:not([value])'
);
assert.isAbove(els1.length, 0);
assert.lengthOf(els2, 0);
```

You should have at least one `textarea` element that is a descendant of `#survey-form`.

```js
const el = document.querySelector('#survey-form textarea');
assert.isNotNull(el);
```

You should have an `input` or `button` element with an `id` of `submit`.

```js
const el = document.getElementById('submit');
assert.isNotNull(el);
assert.isTrue(el.tagName === 'INPUT' || el.tagName === 'BUTTON');
```

Your `#submit` should have a `type` of `submit`.

```js
const el = document.getElementById('submit');
assert.isNotNull(el);
assert.strictEqual(el.type, 'submit');
```

Your `#submit` should be a descendant of `#survey-form`.

```js
const el = document.querySelector('#survey-form #submit');
assert.isNotNull(el);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <title>Survey Form</title>
  </head>

  <body></body>
</html>
```

# --solutions--

```html
<!DOCTYPE html>
<html>
  <head>
    <link rel="stylesheet" href="styles.css" />
  </head>
  <body>
    <div class="container">
      <header class="header">
        <h1 id="title" class="text-center">freeCodeCamp Survey Form</h1>
        <p id="description" class="description text-center">
          Thank you for taking the time to help us improve the platform
        </p>
      </header>
      <form id="survey-form">
        <div class="form-group">
          <label id="name-label" for="name">Name</label>
          <input
            type="text"
            name="name"
            id="name"
            class="form-control"
            placeholder="Enter your name"
            required
          />
        </div>
        <div class="form-group">
          <label id="email-label" for="email">Email</label>
          <input
            type="email"
            name="email"
            id="email"
            class="form-control"
            placeholder="Enter your Email"
            required
          />
        </div>
        <div class="form-group">
          <label id="number-label" for="number"
            >Age<span class="clue">(optional)</span></label
          >
          <input
            type="number"
            name="age"
            id="number"
            min="10"
            max="99"
            class="form-control"
            placeholder="Age"
          />
        </div>
        <div class="form-group">
          <p>Which option best describes your current role?</p>
          <select id="dropdown" name="role" class="form-control" required>
            <option disabled selected value>Select current role</option>
            <option value="student">Student</option>
            <option value="job">Full Time Job</option>
            <option value="learner">Full Time Learner</option>
            <option value="preferNo">Prefer not to say</option>
            <option value="other">Other</option>
          </select>
        </div>

        <div class="form-group">
          <p>Would you recommend freeCodeCamp to a friend?</p>
          <label>
            <input
              name="user-recommend"
              value="definitely"
              type="radio"
              class="input-radio"
              checked
            />Definitely</label
          >
          <label>
            <input
              name="user-recommend"
              value="maybe"
              type="radio"
              class="input-radio"
            />Maybe</label
          >

          <label
            ><input
              name="user-recommend"
              value="not-sure"
              type="radio"
              class="input-radio"
            />Not sure</label
          >
        </div>

        <div class="form-group">
          <p>What is your favorite feature of freeCodeCamp?</p>
          <select id="most-like" name="mostLike" class="form-control" required>
            <option disabled selected value>Select an option</option>
            <option value="challenges">Challenges</option>
            <option value="projects">Projects</option>
            <option value="community">Community</option>
            <option value="openSource">Open Source</option>
          </select>
        </div>

        <div class="form-group">
          <p>
            What would you like to see improved?
            <span class="clue">(Check all that apply)</span>
          </p>

          <label
            ><input
              name="prefer"
              value="front-end-projects"
              type="checkbox"
              class="input-checkbox"
            />Front-end Projects</label
          >
          <label>
            <input
              name="prefer"
              value="back-end-projects"
              type="checkbox"
              class="input-checkbox"
            />Back-end Projects</label
          >
          <label
            ><input
              name="prefer"
              value="data-visualization"
              type="checkbox"
              class="input-checkbox"
            />Data Visualization</label
          >
          <label
            ><input
              name="prefer"
              value="challenges"
              type="checkbox"
              class="input-checkbox"
            />Challenges</label
          >
          <label
            ><input
              name="prefer"
              value="open-source-community"
              type="checkbox"
              class="input-checkbox"
            />Open Source Community</label
          >
          <label
            ><input
              name="prefer"
              value="gitter-help-rooms"
              type="checkbox"
              class="input-checkbox"
            />Gitter help rooms</label
          >
          <label
            ><input
              name="prefer"
              value="videos"
              type="checkbox"
              class="input-checkbox"
            />Videos</label
          >
          <label
            ><input
              name="prefer"
              value="city-meetups"
              type="checkbox"
              class="input-checkbox"
            />City Meetups</label
          >
          <label
            ><input
              name="prefer"
              value="wiki"
              type="checkbox"
              class="input-checkbox"
            />Wiki</label
          >
          <label
            ><input
              name="prefer"
              value="forum"
              type="checkbox"
              class="input-checkbox"
            />Forum</label
          >
          <label
            ><input
              name="prefer"
              value="additional-courses"
              type="checkbox"
              class="input-checkbox"
            />Additional Courses</label
          >
        </div>

        <div class="form-group">
          <p>Any comments or suggestions?</p>
          <textarea
            id="comments"
            class="input-textarea"
            name="comment"
            placeholder="Enter your comment here..."
          ></textarea>
        </div>

        <div class="form-group">
          <button type="submit" id="submit" class="submit-button">
            Submit
          </button>
        </div>
      </form>
    </div>
  </body>
</html>
```
