---
id: 579e2a2c335b9d72dd32e05c
title: Implement the Slice and Splice Algorithm
challengeType: 26
dashedName: implement-the-slice-and-splice-algorithm
---

# --description--

In this lab, you will need to create an algorithm to merge two arrays.

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. Create a `frankenSplice` function that accepts two arrays and an index.
1. Copy each element of the first array into the second array, in order, beginning at the given index, and return the resulting array.
1. The input arrays should remain the same after the function runs.

# --hints--

`frankenSplice([1, 2, 3], [4, 5], 1)` should return `[4, 1, 2, 3, 5]`.

```js
assert.deepEqual(frankenSplice([1, 2, 3], [4, 5], 1), [4, 1, 2, 3, 5]);
```

`frankenSplice([1, 2], ["a", "b"], 1)` should return `["a", 1, 2, "b"]`.

```js
let testArr1 = [1, 2];
let testArr2 = ['a', 'b'];
assert.deepEqual(frankenSplice(testArr1, testArr2, 1), ['a', 1, 2, 'b']);
```

`frankenSplice(["claw", "tentacle"], ["head", "shoulders", "knees", "toes"], 2)` should return `["head", "shoulders", "claw", "tentacle", "knees", "toes"]`.

```js
assert.deepEqual(
  frankenSplice(
    ['claw', 'tentacle'],
    ['head', 'shoulders', 'knees', 'toes'],
    2
  ),
  ['head', 'shoulders', 'claw', 'tentacle', 'knees', 'toes']
);
```

All elements from the first array should be added to the second array in their original order. `frankenSplice([1, 2, 3, 4], [], 0)` should return `[1, 2, 3, 4]`.

```js
assert.deepEqual(frankenSplice([1, 2, 3, 4], [], 0), [1, 2, 3, 4]);
```

The first array should remain the same after the function runs.

```js
let testArr1 = [1, 2];
let testArr2 = ['a', 'b'];
frankenSplice(testArr1, testArr2, 1);
assert.deepEqual(testArr1, [1, 2]);
```

The second array should remain the same after the function runs.

```js
let testArr1 = [1, 2];
let testArr2 = ['a', 'b'];
frankenSplice(testArr1, testArr2, 1);
assert.deepEqual(testArr2, ['a', 'b']);
```

# --seed--

## --seed-contents--

```js

```

# --solutions--

```js
function frankenSplice(arr1, arr2, n) {
  let result = arr2.slice();
  for (let i = 0; i < arr1.length; i++) {
    result.splice(n + i, 0, arr1[i]);
  }
  return result;
}
```
