---
id: 66bb3e20d3dc5b6d0a21f5dd
title: Build a Real Time Counter
challengeType: 25
dashedName: build-a-real-time-counter
demoType: onClick
---

# --description--

In this lab, you will build a real-time character counter by using JavaScript. The character counter will display the number of characters entered in a `textarea` element. The counter will update in real-time as the user types in the `textarea`.

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should have a `textarea` element with the `id` of `text-input`.
2. There should be a `p` element with the `id` of `char-count`. It should initially contain the text `Character Count: 0/50`. This placeholder text should be replaced with the current count of characters in the `textarea` element.
3. When the `#text-input` element contains the text `hello coder` the `#char-count` element should contain the text `"Character Count: 11/50"`
4. When the `#text-input` element contains the text `i am a programmer` the `#char-count` element should contain the text `"Character Count: 17/50"`
5. When the `#text-input` element contains the text `hello world` the `#char-count` element should contain the text `"Character Count: 11/50"`
6. When the `#text-input` element contains the text `I am learning a new language and it is called c++.` the `#char-count` element should contain the text `"Character Count: 50/50"`. **NOTE**: While the `maxlength` attribute would achieve the correct functionality, this lab requires a JavaScript only solution.  
7. The user should not be able to enter more than `50` characters in the `textarea` element. When the character count reaches `50`, any extra input should be automatically trimmed and the text `Character Count: 50/50` should be displayed in `red`.

**Note:** Be sure to link your stylesheet and the JavaScript file in your HTML.

# --hints--

You should have a `textarea` element with the `id` of `text-input`. 

```js
const textInput = document.querySelector('textarea');
assert.equal(textInput.id, 'text-input');
```

You should have a `p` element with the `id` of `char-count`.

```js
const charCount = document.querySelector('p');
assert.equal(charCount.id, 'char-count');
```

The `#char-count` element should initially contain the text `Character Count: 0/50`.

```js
const charCount = document.querySelector('p')?.innerText;
assert.equal(charCount, 'Character Count: 0/50');
```

When the `#text-input` element contains the text `hello coder` the `#char-count` element should contain the text `"Character Count: 11/50"`

```js
const textInput = document.getElementById('text-input');
const charCount = document.getElementById('char-count');
textInput.value = "hello coder";
textInput.dispatchEvent(new Event('input'));
textInput.dispatchEvent(new Event('change'));
assert.strictEqual(charCount.innerText.trim(), 'Character Count: 11/50');
```

When the character count is `50`, the text should be displayed in `red`.

```js
const textInput = document.getElementById('text-input');
const charCount = document.getElementById('char-count');
textInput.value = "I am learning a new language and it is called c++.";
textInput.dispatchEvent(new Event('input'));
textInput.dispatchEvent(new Event('change'));
const computedStyle = window.getComputedStyle(charCount);
assert.oneOf(computedStyle.color, [
  "red",
  "rgb(255, 0, 0)",
  "rgb(100%, 0%, 0%)",
  "rgba(255, 0, 0, 1)",
  "rgba(100%, 0%, 0%, 1)",
  "hsl(0, 100%, 50%)",
  "hsla(0, 100%, 50%, 1)"
]);
```

If character count is greater than or equal to `50`, the extra input should be trimmed.

```js
const textInput = document.getElementById('text-input');
textInput.value = "I am learning a new programming language and it is called c++.";
textInput.dispatchEvent(new Event('input'));
textInput.dispatchEvent(new Event('change'));
assert.strictEqual(textInput.value.length, 50);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Real Time Counter</title>
</head>

<body>

</body>


</html>
```

```css

```

```js
    
```

# --solutions--

```html
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Real-time Character Counter</title>
    <link rel="stylesheet" href="styles.css">

<body>
    <div class="container">
        <h1>Real-Time Character Counter</h1>
        <textarea id="text-input" placeholder="Type something..."></textarea>
        <p id="char-count">Character Count: 0/50</p>
    </div>

<script src="script.js"></script>
</body>

</html>
```

```css
body {
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
    font-family: Arial, sans-serif;
    background-color: #c0c1ec;
    margin: 0;
}

h1{
    background-color: #f2f48b;
    padding-left: 10px;
    padding-right: 10px;
}
.container {
    text-align: center;
}

textarea {
    width: 300px;
    height: 100px;
    font-size: 18px;
    padding: 10px;
    border: 1px solid #ccc;
    border-radius: 5px;
    resize: none;
    display: block;
    margin: 0 auto;
    border: 1px solid slategray;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
}

textarea:focus {
    outline: none;
    border-color: #f2f48b;
}

#char-count {
    margin-top: 10px;
    font-size: 18px;
    color: darkslategray;
    font-weight: bold;
}
```

```js
document.getElementById("text-input").addEventListener("input", function () {
  let textInput = document.getElementById("text-input");
  let charCount = textInput.value.length;

  if (charCount > 50) {
    textInput.value = textInput.value.substring(0, 50);
    charCount = 50;
  }

  let charCountDisplay = document.getElementById("char-count");
  charCountDisplay.innerHTML = `Character Count: ${charCount}/50`;

  if (charCount === 50) {
    charCountDisplay.style.color = "red";
  } 

});
```
