---
id: 66f2836c459cfb16ae76f24f
title: Build a Pyramid Generator
challengeType: 26
dashedName: lab-pyramid-generator
---

# --description--

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should have a function named `pyramid` that takes three arguments.
1. The first argument should be a string representing the pattern character to repeat in your pyramid.
1. The second argument should be an integer representing the number of rows in the pyramid.
1. The third argument should be a Boolean value.
1. The `pyramid` function should return a string in which the pattern character is repeated and arranged to form a pyramid having the vertex facing upwards when the third argument is `false`.
1. When the third argument is `true` the pyramid should have the vertex facing downwards.
1. The vertex row should have a single pattern character, and each other row should have two pattern characters more than the previous one.
1. Each row should start with a number of spaces sufficient to put the center character of each row in the same column and there should not be any spaces at the end of each row.
1. The pyramid should start and end with a newline character.

For example, calling `pyramid("o", 4, false)` should give this output:

```js

   o
  ooo
 ooooo
ooooooo

```

# --hints--

You should have a function named `pyramid`.

```js
assert.isFunction(pyramid);
```

Your `pyramid` function should have three parameters.

```js
assert.lengthOf(pyramid, 3);
```

`pyramid("o", 4, false)` should return `"\n   o\n  ooo\n ooooo\nooooooo\n"`.

```js
assert.equal(pyramid("o", 4, false), "\n   o\n  ooo\n ooooo\nooooooo\n")
```

`pyramid("p", 5, true)` should return `"\nppppppppp\n ppppppp\n  ppppp\n   ppp\n    p\n"`.

```js
assert.equal(pyramid("p", 5, true), "\nppppppppp\n ppppppp\n  ppppp\n   ppp\n    p\n")
```

# --seed--

## --seed-contents--

```js

```

# --solutions--

```js
function pyramid(char, count, isInverted) {
    const rows = []
    for (let i = 1; i <= count; i++) {
        if (isInverted) {
            rows.unshift(" ".repeat(count - i) + char.repeat(2 * i - 1))
        } else {
            rows.push(" ".repeat(count - i) + char.repeat(2 * i - 1))
        }        
    }
    return "\n" + rows.join("\n") + "\n";
}

console.log(pyramid("#", 10, false))

```
