---
id: 5688e62ea601b2482ff8422b
title: Build a Profile Lookup
challengeType:  26
dashedName: lab-profile-lookup
---

# --description--

In this lab, you will build a profile lookup that looks up information about people in a contacts list.

For this example imagine there is a contact named Akira Laine, the `lookUpProfile("Akira", "lastName")` should return `Laine`. 

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should create a function named `lookUpProfile` that takes a name and a property as arguments. 
2. You should retrieve contact information from the provided `contacts` array. 
3. If the function receives a contact name and the property exists on the related contact, then the property's value should be returned.
4. If the name passed to the function does not match any contacts in the contacts array, then the function should return `"No such contact"`.
5. If the property does not exist on a found contact, then the function should return `"No such property"`. 

# --before-each--

```js
contacts = [
  {
    firstName: "Akira",
    lastName: "Laine",
    number: "0543236543",
    likes: ["Pizza", "Coding", "Brownie Points"],
  },
  {
    firstName: "Harry",
    lastName: "Potter",
    number: "0994372684",
    likes: ["Hogwarts", "Magic", "Hagrid"],
  },
  {
    firstName: "Sherlock",
    lastName: "Holmes",
    number: "0487345643",
    likes: ["Intriguing Cases", "Violin"],
  },
  {
    firstName: "Kristian",
    lastName: "Vos",
    number: "unknown",
    likes: ["JavaScript", "Gaming", "Foxes"],
  },
];
```

# --hints--

The `contacts` array should still be present in the global scope. Reset the lesson to recover it if you deleted it.

```js
assert.isArray(contacts);
```

You should have a function named `lookUpProfile`.

```js
assert.isFunction(lookUpProfile);
```

`lookUpProfile("Kristian", "lastName")` should return a string.

```js
assert.isString(lookUpProfile("Kristian", "lastName"));
```

`lookUpProfile("Kristian", "lastName")` should return the string `Vos`

```js
assert.strictEqual(lookUpProfile('Kristian', 'lastName'), 'Vos');
```

`lookUpProfile("Sherlock", "likes")` should return `["Intriguing Cases", "Violin"]`

```js
assert.deepEqual(lookUpProfile('Sherlock', 'likes'), [
  'Intriguing Cases',
  'Violin'
]);
```

`lookUpProfile("Harry", "likes")` should return an array

```js
assert.isArray(lookUpProfile('Harry', 'likes'));
```

`lookUpProfile("Bob", "number")` should return the string `No such contact`

```js
assert.strictEqual(lookUpProfile('Bob', 'number'),'No such contact');
```

`lookUpProfile("Bob", "potato")` should return the string `No such contact`

```js
assert.strictEqual(lookUpProfile('Bob', 'potato'), 'No such contact');
```

`lookUpProfile("Akira", "address")` should return the string `No such property`

```js
assert.strictEqual(lookUpProfile('Akira', 'address'), 'No such property');
```

# --seed--

## --seed-contents--

```js
let contacts = [
  {
    firstName: "Akira",
    lastName: "Laine",
    number: "0543236543",
    likes: ["Pizza", "Coding", "Brownie Points"],
  },
  {
    firstName: "Harry",
    lastName: "Potter",
    number: "0994372684",
    likes: ["Hogwarts", "Magic", "Hagrid"],
  },
  {
    firstName: "Sherlock",
    lastName: "Holmes",
    number: "0487345643",
    likes: ["Intriguing Cases", "Violin"],
  },
  {
    firstName: "Kristian",
    lastName: "Vos",
    number: "unknown",
    likes: ["JavaScript", "Gaming", "Foxes"],
  },
];


```

# --solutions--

```js
let contacts = [
  {
    firstName: "Akira",
    lastName: "Laine",
    number: "0543236543",
    likes: ["Pizza", "Coding", "Brownie Points"],
  },
  {
    firstName: "Harry",
    lastName: "Potter",
    number: "0994372684",
    likes: ["Hogwarts", "Magic", "Hagrid"],
  },
  {
    firstName: "Sherlock",
    lastName: "Holmes",
    number: "0487345643",
    likes: ["Intriguing Cases", "Violin"],
  },
  {
    firstName: "Kristian",
    lastName: "Vos",
    number: "unknown",
    likes: ["JavaScript", "Gaming", "Foxes"],
  },
];


function lookUpProfile(name, prop) {
  for (let i in contacts) {
    if (contacts[i].firstName === name) {
      return contacts[i][prop] || "No such property";
    }
  }
  return "No such contact";
}
```
